package com.bcxin.tenant.open.dubbo.writer.providers.impls;

import com.bcxin.tenant.open.document.domains.utils.GeoPointUtils;
import com.bcxin.tenant.open.domains.entities.RdWorkstationEntity;
import com.bcxin.tenant.open.domains.repositories.RdWorkstationRepository;
import com.bcxin.tenant.open.infrastructures.enums.ReferenceType;
import com.bcxin.tenant.open.jdks.WorkstationRpcProvider;
import com.bcxin.tenant.open.jdks.responses.WorkstationResponse;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.data.geo.Point;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.util.StringUtils;

import java.util.Collection;
import java.util.stream.Collectors;

@DubboService
public class WorkstationRpcProviderImpl implements WorkstationRpcProvider {
    private final RdWorkstationRepository workstationRepository;
    private final RedisTemplate redisTemplate;

    public WorkstationRpcProviderImpl(RdWorkstationRepository workstationRepository, RedisTemplate redisTemplate) {
        this.workstationRepository = workstationRepository;
        this.redisTemplate = redisTemplate;
    }

    @Override
    public Collection<WorkstationResponse> getWorkstationsByEmployeeId(String employeeId) {
        Collection<RdWorkstationEntity> workstations
                = this.workstationRepository.getByEmployeeId(employeeId);

        Collection<WorkstationResponse> rps = workstations.stream().map(ii -> {
            Point point = GeoPointUtils.translate(ii.getLonLat());
            double performRange = 0d;
            if (StringUtils.hasLength(ii.getPerformRange())) {
                try {
                    performRange = Double.parseDouble(ii.getPerformRange());
                } catch (Exception ex) {

                }
            }

            WorkstationResponse response =
                    WorkstationResponse.create(
                            ii.getReferenceType() == ReferenceType.JobStation ? String.valueOf(ii.getId()) : ii.getReferenceNumber(),
                            point == null ? null : point.getY(),
                            point == null ? null : point.getX(),
                            ii.getDisplayOrder(),
                            ii.getDisplayName(),
                            ii.getAddress(),
                            performRange,
                            ii.getReferenceType(),
                            ii.getReferenceLineId()
                    );

            return response;
        }).collect(Collectors.toList());

        return rps;
    }
}
