package com.bcxin.tenant.open.dubbo.writer.providers.impls;

import com.bcxin.tenant.open.domains.repositories.TencentCallbackLogRepository;
import com.bcxin.tenant.open.domains.services.TencentCallbackLogService;
import com.bcxin.tenant.open.domains.services.commands.CreateTencentCallbackLogCommand;
import com.bcxin.tenant.open.domains.services.commands.ProcessTencentCallbackLogCommand;
import com.bcxin.tenant.open.jdks.TencentCallbackLogRpcProvider;
import com.bcxin.tenant.open.jdks.requests.TencentCalculateCallLogRequest;
import com.bcxin.tenant.open.jdks.requests.TencentCallbackRequest;
import org.apache.commons.lang3.ThreadUtils;
import org.apache.dubbo.config.annotation.DubboService;
import org.apache.dubbo.config.annotation.Method;

import java.time.Duration;
import java.util.Collection;

@DubboService(methods = {
        @Method(name = "execute",async = false)
})
public class TencentCallbackLogRpcProviderImpl implements TencentCallbackLogRpcProvider {
    private final TencentCallbackLogService tencentCallbackLogService;
    private final TencentCallbackLogRepository tencentCallbackLogRepository;

    public TencentCallbackLogRpcProviderImpl(TencentCallbackLogService tencentCallbackLogService,
                                             TencentCallbackLogRepository tencentCallbackLogRepository) {
        this.tencentCallbackLogService = tencentCallbackLogService;
        this.tencentCallbackLogRepository = tencentCallbackLogRepository;
    }

    @Override
    public void create(TencentCallbackRequest request) {
        this.tencentCallbackLogService.dispatch(
                CreateTencentCallbackLogCommand.create(
                        request.getData()
                )
        );
    }

    @Override
    public void execute(TencentCalculateCallLogRequest request) {
        ProcessTencentCallbackLogCommand command =
                ProcessTencentCallbackLogCommand.create(request.getRoomIds());

        this.tencentCallbackLogService.dispatch(command);
    }
}
