package com.bcxin.tenant.open.dubbo.writer.providers.impls;

import com.bcxin.tenant.open.domains.services.TenantWarnContentService;
import com.bcxin.tenant.open.domains.services.commands.CreateTenantWarnContentCommand;
import com.bcxin.tenant.open.infrastructures.enums.ContentType;
import com.bcxin.tenant.open.infrastructures.enums.DispatchDataType;
import com.bcxin.tenant.open.jdks.RdSyncRpcWriterProvider;
import com.bcxin.tenant.open.jdks.TenantWarnContentRpcProvider;
import com.bcxin.tenant.open.jdks.requests.SyncParameterWrapperRequest;
import com.bcxin.tenant.open.jdks.requests.TenantWarnContentRequest;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@DubboService(async = true)
public class TenantWarnContentRpcProviderImpl implements TenantWarnContentRpcProvider {
    private static final Logger logger = LoggerFactory.getLogger(TenantWarnContentRpcProviderImpl.class);

    private final TenantWarnContentService tenantWarnContentService;
    private final RdSyncRpcWriterProvider syncRpcWriterProvider;

    public TenantWarnContentRpcProviderImpl(TenantWarnContentService tenantWarnContentService,
                                            RdSyncRpcWriterProvider syncRpcWriterProvider) {
        this.tenantWarnContentService = tenantWarnContentService;
        this.syncRpcWriterProvider = syncRpcWriterProvider;
    }

    @Override
    public void dispatch(TenantWarnContentRequest request) {
        if (request.getContentType() == ContentType.Employee) {
            try {
                CompletableFuture.runAsync(() -> {
                    this.syncRpcWriterProvider.sync(
                            SyncParameterWrapperRequest.create(
                                    DispatchDataType.Employee,
                                    Stream.of(request.getReferenceNumber()).collect(Collectors.toList()))
                    );
                });
            } catch (Exception ex) {
                logger.error("failed to hold up warn content execute:{}", request.getReferenceNumber(), ex);
            }
        }

        this.tenantWarnContentService.dispatch(
                CreateTenantWarnContentCommand.create(request.getContentType(),
                        request.getReferenceNumber(),
                        request.getContent()
                )
        );
    }
}
