package com.bcxin.tenant.open.dubbo.writer.providers.impls;

import com.bcxin.tenant.open.domains.services.TenantContentFollowService;
import com.bcxin.tenant.open.domains.services.commands.CancelTenantContentFollowCommand;
import com.bcxin.tenant.open.domains.services.commands.CreateTenantContentFollowCommand;
import com.bcxin.tenant.open.infrastructures.TenantContext;
import com.bcxin.tenant.open.infrastructures.TenantEmployeeContext;
import com.bcxin.tenant.open.jdks.TenantContentFollowWriterRpcProvider;
import com.bcxin.tenant.open.jdks.requests.DispatchContentFollowRequest;
import org.apache.dubbo.config.annotation.DubboService;

@DubboService
public class TenantContentFollowWriterRpcProviderImpl implements TenantContentFollowWriterRpcProvider {
    private final TenantContentFollowService contentFollowService;

    public TenantContentFollowWriterRpcProviderImpl(TenantContentFollowService contentFollowService) {
        this.contentFollowService = contentFollowService;
    }

    @Override
    public void doPatch(DispatchContentFollowRequest request) {
        TenantEmployeeContext.TenantUserModel userModel = TenantContext.getInstance().getUserContext().get();
        if (request.isFollow()) {
            this.contentFollowService.dispatch(
                    CreateTenantContentFollowCommand.create(
                            request.getFollowType(),
                            request.getContentFollowId(),
                            userModel.getTencentUserId(),
                            userModel.getEmployeeId()
                    )
            );
        } else {
            this.contentFollowService.dispatch(
                    CancelTenantContentFollowCommand.create(
                            request.getFollowType(),
                            request.getContentFollowId(),
                            userModel.getTencentUserId(),
                            userModel.getEmployeeId()
                    )
            );
        }
    }
}
