package com.bcxin.tenant.open.dubbo.writer.providers.impls;

import com.bcxin.tenant.open.infrastructures.exceptions.NotSupportTenantException;
import com.bcxin.tenant.open.jdks.*;
import com.bcxin.tenant.open.jdks.requests.SyncSlaveWriterRequest;
import org.apache.dubbo.config.annotation.DubboService;

@DubboService
public class SyncSlaveWriterRpcProviderImpl implements SyncSlaveWriterRpcProvider {
    private final CompanyWriterRpcProvider companyWriterRpcProvider;
    private final EmployeeWriterRpcProvider employeeWriterRpcProvider;
    private final SecurityStationWriterRpcProvider securityStationWriterRpcProvider;
    private final SecurityStationPersonWriterRpcProvider securityStationPersonWriterRpcProvider;
    private final DeviceCommunicatedLogDetailWriterRpcProvider deviceCommunicatedLogDetailWriterRpcProvider;
    private final DeviceCommunicatedLogWriterRpcProvider deviceCommunicatedLogWriterRpcProvider;

    public SyncSlaveWriterRpcProviderImpl(CompanyWriterRpcProvider companyWriterRpcProvider,
                                          EmployeeWriterRpcProvider employeeWriterRpcProvider,
                                          SecurityStationWriterRpcProvider securityStationWriterRpcProvider,
                                          SecurityStationPersonWriterRpcProvider securityStationPersonWriterRpcProvider,
                                          DeviceCommunicatedLogDetailWriterRpcProvider deviceCommunicatedLogDetailWriterRpcProvider,
                                          DeviceCommunicatedLogWriterRpcProvider deviceCommunicatedLogWriterRpcProvider) {
        this.companyWriterRpcProvider = companyWriterRpcProvider;
        this.employeeWriterRpcProvider = employeeWriterRpcProvider;
        this.securityStationWriterRpcProvider = securityStationWriterRpcProvider;
        this.securityStationPersonWriterRpcProvider = securityStationPersonWriterRpcProvider;
        this.deviceCommunicatedLogDetailWriterRpcProvider = deviceCommunicatedLogDetailWriterRpcProvider;
        this.deviceCommunicatedLogWriterRpcProvider = deviceCommunicatedLogWriterRpcProvider;
    }

    @Override
    public void flush(SyncSlaveWriterRequest request) {
        switch (request.getDataType()) {
            case RdCompany -> {
                this.companyWriterRpcProvider.flush2DbRedis(request.getContent());
                return;
            }
            case RdStation -> {
                this.securityStationWriterRpcProvider.flush2DbRedis(request.getContent());
                return;
            }
            case RdEmployee -> {
                this.employeeWriterRpcProvider.flush2DbRedis(request.getContent());
                return;
            }
            case RdStationPerson -> {
                this.securityStationPersonWriterRpcProvider.flush2DbRedis(request.getContent());
                return;
            }
            case DeviceCommunicatedLog -> {
                this.deviceCommunicatedLogWriterRpcProvider.flush(request.getContent());
                return;
            }
            case DeviceCommunicatedLogDetail -> {
                this.deviceCommunicatedLogDetailWriterRpcProvider.flush(request.getContent());
                return;
            }
        }

        throw new NotSupportTenantException(String.format("不支持该类型:%s", request.getDataType()));
    }
}
