package com.bcxin.tenant.open.dubbo.writer.providers.impls;

import com.bcxin.tenant.open.domains.entities.StationDeviceEntity;
import com.bcxin.tenant.open.domains.repositories.StationDeviceRepository;
import com.bcxin.tenant.open.jdks.StationDeviceRpcProvider;
import com.bcxin.tenant.open.jdks.requests.StationDeviceSearchRequest;
import com.bcxin.tenant.open.jdks.responses.StationDeviceResponse;
import org.apache.dubbo.config.annotation.DubboService;

import java.util.Collection;
import java.util.stream.Collectors;

@DubboService
public class StationDeviceRpcProviderImpl implements StationDeviceRpcProvider {

    private final StationDeviceRepository stationDeviceRepository;

    public StationDeviceRpcProviderImpl(StationDeviceRepository stationDeviceRepository) {
        this.stationDeviceRepository = stationDeviceRepository;
    }

    @Override
    public Collection<StationDeviceResponse> search(StationDeviceSearchRequest request) {
        Collection<StationDeviceEntity> stationDevices =
                this.stationDeviceRepository.getByStationIds(request.getStationIds());

        return stationDevices.stream().map(ii -> StationDeviceResponse.create(
                ii.getId(),
                ii.getStationId(),
                ii.getThirdPartyId(),
                ii.getThirdPartyName()
        )).collect(Collectors.toList());
    }
}
