package com.bcxin.tenant.open.dubbo.writer.providers.impls;

import com.bcxin.tenant.open.domains.criterias.RdSecurityStationRailMessageCriteria;
import com.bcxin.tenant.open.domains.entities.RdSecurityStationRailMessageEntity;
import com.bcxin.tenant.open.domains.repositories.RdSecurityStationRailMessageRepository;
import com.bcxin.tenant.open.infrastructures.EntityCollection;
import com.bcxin.tenant.open.infrastructures.TenantContext;
import com.bcxin.tenant.open.infrastructures.TenantEmployeeContext;
import com.bcxin.tenant.open.jdks.SecurityStationRailMessageRpcProvider;
import com.bcxin.tenant.open.jdks.requests.SecurityStationRailMessageSearchRequest;
import com.bcxin.tenant.open.jdks.responses.SecurityStationRailMessageOverviewResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboService;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;

@DubboService
public class SecurityStationRailMessageRpcProviderImpl implements SecurityStationRailMessageRpcProvider {

    private final RdSecurityStationRailMessageRepository rdSecurityStationRailMessageRepository;

    public SecurityStationRailMessageRpcProviderImpl(RdSecurityStationRailMessageRepository rdSecurityStationRailMessageRepository){
        this.rdSecurityStationRailMessageRepository = rdSecurityStationRailMessageRepository;
    }

    @Override
    public EntityCollection<SecurityStationRailMessageOverviewResponse> search(SecurityStationRailMessageSearchRequest request) {
        int pageIndex = request.getPageIndex();
        if (pageIndex < 1) {
            pageIndex = 1;
        }
        TenantEmployeeContext.TenantUserModel userModel = TenantContext.getInstance().getUserContext().get();
        Collection<String> currentSuperviseDepartIds = null;
        String[] organizationIds = null;
        if (userModel.isSuperviseDepartRole()) {
            /**
             * 查询可调度的监管Id
             */
            if (userModel.getAssignedSuperviseDepartIds() == null) {
                return EntityCollection.EMPTY();
            }

            currentSuperviseDepartIds = Arrays.asList(userModel.getAssignedSuperviseDepartIds());
        } else {
            /**
             * 仅查询自己企业数据
             */
            if (userModel.getOrganizationId() == null) {
                return EntityCollection.EMPTY();
            }
            organizationIds = userModel.getNoSuperviseScopePermissions();
        }

        RdSecurityStationRailMessageCriteria criteria =
        RdSecurityStationRailMessageCriteria.create(
                request.getDeskTypes(),
                request.getEmployeeName(),
                request.getCompanyName(), request.getRailReferenceName(),request.getProjectName(),
                request.getSuperviseDepartIds(),
                request.getEventStartDate(), request.getEventEndDate(), request.getEmployeeIdCardNo(),
                pageIndex,
                request.getPageSize(), currentSuperviseDepartIds, organizationIds);

        criteria.setForExport(request.isForExport());
        EntityCollection<RdSecurityStationRailMessageEntity> data =
                rdSecurityStationRailMessageRepository.search(criteria);

        Collection<SecurityStationRailMessageOverviewResponse> overviewResponses = data.getData().stream().map(ix -> {
            SecurityStationRailMessageOverviewResponse
                    response = SecurityStationRailMessageOverviewResponse.create(
                    ix.getPkId(),
                    ix.getEventTime(),
                    ix.getRailRuleType(),
                    ix.getStationRailName(),
                    ix.getEmployeeName(),
                    ix.getEmployeeIdCardNo(),
                    ix.getCompanyName(),
                    ix.getRailReferenceName(),
                    ix.getRailReferenceAddress(),
                    ix.getRailReferenceSuperviseDepartName(),
                    ix.getProjectId(),
                    ix.getProjectName()
            );

            return response;
        }).collect(Collectors.toList());

        return EntityCollection.create(overviewResponses, data.getPageSize(), data.getTotalCount());
    }
}
