package com.bcxin.tenant.open.dubbo.writer.providers.impls;

import com.bcxin.tenant.open.document.domains.documents.RdSecurityStationDocument;
import com.bcxin.tenant.open.document.domains.repositories.RdSecurityStationDocumentRepository;
import com.bcxin.tenant.open.domains.dtos.SecurityStationCountDTO;
import com.bcxin.tenant.open.domains.repositories.RdSecurityStationPersonRepository;
import com.bcxin.tenant.open.domains.services.RdEmployeeService;
import com.bcxin.tenant.open.domains.services.SecurityStationPersonService;
import com.bcxin.tenant.open.domains.services.SecurityStationService;
import com.bcxin.tenant.open.domains.services.commands.CreateSecurityStationPersonCommand;
import com.bcxin.tenant.open.domains.services.commands.RefreshEmployeeStationCommand;
import com.bcxin.tenant.open.domains.services.commands.RefreshStationCountOfSecurityManCommand;
import com.bcxin.tenant.open.jdks.EmployeeWriterRpcProvider;
import com.bcxin.tenant.open.jdks.SecurityStationPersonWriterRpcProvider;
import com.bcxin.tenant.open.jdks.requests.FlushStationPersonRequest;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.util.CollectionUtils;

import java.util.Collection;
import java.util.stream.Collectors;

@DubboService
public class SecurityStationPersonWriterRpcProviderImpl implements SecurityStationPersonWriterRpcProvider {
    private final RdSecurityStationPersonRepository securityStationPersonRepository;
    private final RdSecurityStationDocumentRepository securityStationDocumentRepository;
    private final EmployeeWriterRpcProvider employeeWriterRpcProvider;
    private final RdEmployeeService rdEmployeeService;
    private final SecurityStationService securityStationService;
    private final SecurityStationPersonService securityStationPersonService;

    public SecurityStationPersonWriterRpcProviderImpl(RdSecurityStationPersonRepository securityStationPersonRepository,
                                                      RdSecurityStationDocumentRepository securityStationDocumentRepository,
                                                      EmployeeWriterRpcProvider employeeWriterRpcProvider, RdEmployeeService rdEmployeeService, SecurityStationService securityStationService, SecurityStationPersonService securityStationPersonService) {
        this.securityStationPersonRepository = securityStationPersonRepository;
        this.securityStationDocumentRepository = securityStationDocumentRepository;
        this.employeeWriterRpcProvider = employeeWriterRpcProvider;
        this.rdEmployeeService = rdEmployeeService;
        this.securityStationService = securityStationService;
        this.securityStationPersonService = securityStationPersonService;
    }



    @Override
    public int flush2RedisByStationIds(FlushStationPersonRequest request) {
        //直接更新到Station及职员的信息表
        //int affectedCount = execute_Flush2RedisByStationIds(request.getStationIds());
        /**
         * 先禁用; 归集的时候已经实时计算 by lhc:20230425
         */
        this.securityStationService.dispatch(RefreshStationCountOfSecurityManCommand.create(
                request.getStationIds().stream().distinct().collect(Collectors.toList())));
        this.rdEmployeeService.dispatch(RefreshEmployeeStationCommand.create(request.getEmployeeIds().stream()
                .distinct().collect(Collectors.toList())));

        return 0;
    }

    @Override
    public void flush2DbRedis(String content) {
        securityStationPersonService.dispatch(CreateSecurityStationPersonCommand.create(content));
    }

    /**
     * 刷新总的保安人数量
     * @param stationIds
     * @return
     */
    private int execute_Flush2RedisByStationIds(Collection<String> stationIds) {
        if (CollectionUtils.isEmpty(stationIds)) {
            return 0;
        }

        Collection<RdSecurityStationDocument> documents =
                securityStationDocumentRepository.findAllById(stationIds);
        if (!CollectionUtils.isEmpty(documents)) {
            return 0;
        }

        Collection<SecurityStationCountDTO> countOfStations =
                this.securityStationPersonRepository.getCountOfPersonByStationIds(stationIds);
        /*
        Collection<SecurityStationCountDTO> countOfStations =
                this.securityStationPersonRepository.getCountOfPersonByStationIds(stationIds);

        documents.forEach(ii -> {
            Optional<SecurityStationCountDTO> securityStationCountDTOOptional
                    = countOfStations.stream().filter(ix -> ix.getStationId().equals(ii.getId()))
                    .findFirst();

            if (securityStationCountDTOOptional.isPresent()) {
                ii.setCountOfSecurityMan(securityStationCountDTOOptional.get().getTotal());
            }
        });

        this.securityStationDocumentRepository.saveAll(documents);

         */

        return documents.size();
    }

    private int execute_Flush2RedisByPersonId(Collection<String> employeeIds) {
        if (CollectionUtils.isEmpty(employeeIds)) {
            return 0;
        }

        int affectedCount = this.employeeWriterRpcProvider.flushStation2Redis(employeeIds);

        return affectedCount;
    }
}
