package com.bcxin.tenant.open.dubbo.writer.providers.impls;

import com.bcxin.tenant.open.document.domains.documents.InstantActivityDataDocument;
import com.bcxin.tenant.open.document.domains.documents.InstantActivityDataDocument$;
import com.bcxin.tenant.open.document.domains.documents.RollCallProgressStatusDocument;
import com.bcxin.tenant.open.document.domains.documents.RollCallProgressStatusDocument$;
import com.bcxin.tenant.open.domains.services.RollCallService;
import com.bcxin.tenant.open.domains.services.commands.*;
import com.bcxin.tenant.open.domains.services.commands.results.CancelRollCallEmployeeCommandResult;
import com.bcxin.tenant.open.domains.services.commands.results.CreateRollCallCommandResult;
import com.bcxin.tenant.open.dubbo.writer.providers.dtos.SelectedRoomEmployeeMapDTO;
import com.bcxin.tenant.open.infrastructures.components.JsonProvider;
import com.bcxin.tenant.open.infrastructures.enums.RollCallStatus;
import com.bcxin.tenant.open.infrastructures.enums.RollCallType;
import com.bcxin.tenant.open.infrastructures.enums.TRTCActionType;
import com.bcxin.tenant.open.infrastructures.exceptions.ArgumentTenantException;
import com.bcxin.tenant.open.infrastructures.exceptions.NoFoundTenantException;
import com.bcxin.tenant.open.jdks.RollCallWriterRpcProvider;
import com.bcxin.tenant.open.jdks.requests.*;
import com.bcxin.tenant.open.jdks.responses.CreateRollCallResponse;
import com.bcxin.tenant.open.jdks.responses.RollCallAutoCancelEmployeeResponse;
import com.bcxin.tenant.open.jdks.responses.RollCallProgressStatusResponse;
import com.redis.om.spring.search.stream.EntityStream;
import com.redis.om.spring.search.stream.SearchStream;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;

/**
 * 点名轮换实例
 */
@DubboService
public class RollCallWriterRpcProviderImpl implements RollCallWriterRpcProvider {
    private static final Logger logger = LoggerFactory.getLogger(RollCallWriterRpcProviderImpl.class);
    private final RollCallService rollCallService;
    private final EntityStream entityStream;
    private final JsonProvider jsonProvider;

    public RollCallWriterRpcProviderImpl(RollCallService rollCallService,
                                         EntityStream entityStream,
                                         JsonProvider jsonProvider) {
        this.rollCallService = rollCallService;
        this.entityStream = entityStream;
        this.jsonProvider = jsonProvider;
    }

    @Override
    public CreateRollCallResponse create(CreateRollCallRequest request) {
        if(request.getOperator()==null) {
            throw new ArgumentTenantException("操作人不能为空");
        }

        CreateRollCallCommand.DoActionOperatorCommandItem operator
                = CreateRollCallCommand.DoActionOperatorCommandItem.create(
                request.getOperator().getActionOrganizationId(),
                request.getOperator().getActionOrgInstitutional(),
                request.getOperator().getActionOrganizationName(),
                request.getOperator().getActionEmployeeId(),
                request.getOperator().getActionEmployeeName()
        );

        CreateRollCallCommandResult commandResult =
                this.rollCallService.dispatch(
                        CreateRollCallCommand.create(
                                request.getRollCallPlanId(),
                                request.getTimeValue(),
                                request.getSuperviseDepartIds(),
                                request.getSecurityStationIds(),
                                request.getStationTypes(),
                                operator
                        ));

        return CreateRollCallResponse.create(commandResult.getRollCallId(), commandResult.getCountOfRollCallPerson());
    }

    @Override
    public void dispatch(BatchRollCallEmployeeRequest request) {
        this.rollCallService.dispatch(BatchRollCallEmployeeCommand.create(request.getData()));
    }

    @Override
    public void dispatch(AppReplyRollCallEmployeeStatusRequest request) {
        this.rollCallService.dispatch(
                ReplyRollCallEmployeeStatusCommand.create(
                request.getId(), request.getEmployeeIds(),
                RollCallType.RollCall,
                RollCallStatus.RollCallSuccess));
    }

    @Override
    public void dispatch(RollCallBatchDispatchRequest request) {
        Collection<RollCallBatchDispatchCommand.RollCallBatchDispatchCommandItem>
                items = request.getItems().stream().map(ii -> RollCallBatchDispatchCommand.RollCallBatchDispatchCommandItem.create(
                ii.getRollCallId(), ii.getEmployeeIds(), ii.getRoomId()
        )).collect(Collectors.toList());

        RollCallBatchDispatchCommand command = RollCallBatchDispatchCommand.create(items);

        this.rollCallService.dispatch(command);
    }

    @Override
    public RollCallAutoCancelEmployeeResponse dispatch(RollCallAutoCancelEmployeeRequest request) {
        CancelRollCallEmployeeCommandResult result = this.rollCallService.dispatch(CancelRollCallEmployeeCommand.create(request.getCallStatus()));

        return RollCallAutoCancelEmployeeResponse.create(
                result.getItems().stream().map(ix -> RollCallAutoCancelEmployeeResponse.RollCallAutoCancelEmployeeResponseItem.create(
                        ix.getRollCallEmployeeId(),
                        ix.getRollCallStatus()
                )).collect(Collectors.toList())
        );
    }

    @Override
    public void dispatch(RollCallBatchEmployeeRoomActionRequest request) {
        if (CollectionUtils.isEmpty(request.getData())) {
            return;
        }

        Collection<SelectedRoomEmployeeMapDTO> roomEmployeeMapDTOS =
                request.getData().stream()
                        .filter(ii -> ii.getEmployeeIds() != null && (ii.getActionType() == TRTCActionType.ANSWER || ii.getActionType() == TRTCActionType.REFUSE))
                        .flatMap(ii ->
                                ii.getEmployeeIds().stream().map(ix -> {
                                    return SelectedRoomEmployeeMapDTO.create(
                                            InstantActivityDataDocument.generateId(String.valueOf(ii.getId()), ix), ix, ii.getActionType());
                                })
                        ).collect(Collectors.toList());
        String[] selectedIds = roomEmployeeMapDTOS.stream().map(ii -> ii.getId()).toArray(ix -> new String[ix]);

        if (selectedIds.length == 0) {
            return;
        }

        SearchStream<InstantActivityDataDocument> instantActivityDataDocumentSearchStream =
                this.entityStream.of(InstantActivityDataDocument.class);
        instantActivityDataDocumentSearchStream =
                instantActivityDataDocumentSearchStream.filter(InstantActivityDataDocument$.ID.in(selectedIds));

        Collection<InstantActivityDataDocument> instantActivityDataDocuments =
                instantActivityDataDocumentSearchStream.collect(Collectors.toList());


        Collection<RollCallBatchEmployeeRoomActionCommand.RollCallReplyEmployeeCommandItem> items =
                instantActivityDataDocuments.stream().map(ii -> {
                    SelectedRoomEmployeeMapDTO dt = roomEmployeeMapDTOS.stream()
                            .filter(ix -> ix.getId().equals(ii.getId()))
                            .findFirst().orElse(null);
                    if (dt == null) {
                        return null;
                    }

                    try {
                        RollCallStatus status = dt.getActionType() == TRTCActionType.ANSWER ? RollCallStatus.DispatchSuccess : RollCallStatus.DispatchFailed;
                        return RollCallBatchEmployeeRoomActionCommand.RollCallReplyEmployeeCommandItem.create(
                                Long.parseLong(ii.getBusinessValue()),
                                dt.getEmployeeId(),
                                ii.getBusinessValue(),
                                ii.getReferenceNumber(),
                                status);
                    } catch (Exception ex) {
                        logger.error("解析RollCallBatchEmployeeRoomActionRequest 操作发生异常:{}",
                                this.jsonProvider.getJson(ii),
                                ex);

                        return null;
                    }
                }).filter(ii -> ii != null).collect(Collectors.toList());

        this.rollCallService.dispatch(
                RollCallBatchEmployeeRoomActionCommand.create(
                        items
                )
        );
    }

    @Override
    public Collection<RollCallProgressStatusResponse> getProgressStatus(Collection<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Collections.EMPTY_LIST;
        }

        Long[] selectedIds = ids.toArray(ix -> new Long[ix]);
        SearchStream<RollCallProgressStatusDocument> rollCallProgressStatusDocumentSearchStream =
                this.entityStream.of(RollCallProgressStatusDocument.class)
                        .filter(RollCallProgressStatusDocument$.ID.in(selectedIds));

        Collection<RollCallProgressStatusDocument> documents =
                rollCallProgressStatusDocumentSearchStream.collect(Collectors.toList());

        return documents.stream().map(ii -> {
            return RollCallProgressStatusResponse.create(ii.getId(), ii.getCountOfMembers(), ii.getCountOfProcessed());
        }).collect(Collectors.toList());
    }
}
