package com.bcxin.tenant.open.dubbo.writer.providers.impls;

import com.bcxin.tenant.open.document.domains.documents.RdDispatchDataScopeDocument;
import com.bcxin.tenant.open.document.domains.documents.RdSyncStatusDocument;
import com.bcxin.tenant.open.document.domains.repositories.RdDispatchDataScopeDocumentRepository;
import com.bcxin.tenant.open.document.domains.repositories.RdSyncStatusDocumentRepository;
import com.bcxin.tenant.open.domains.components.HotCacheManager;
import com.bcxin.tenant.open.domains.dtos.SyncDataWrapperDTO;
import com.bcxin.tenant.open.domains.dtos.SyncDbCheckQueryDTO;
import com.bcxin.tenant.open.domains.events.ProprietorCompanyChangedIntegrationEvent;
import com.bcxin.tenant.open.domains.repositories.RdSyncDataRepository;
import com.bcxin.tenant.open.dubbo.writer.providers.components.RefreshIndexComponent;
import com.bcxin.tenant.open.infrastructures.UnitWork;
import com.bcxin.tenant.open.infrastructures.components.RetryProvider;
import com.bcxin.tenant.open.infrastructures.enums.ContentType;
import com.bcxin.tenant.open.infrastructures.enums.DispatchDataScopeType;
import com.bcxin.tenant.open.infrastructures.enums.DispatchDataType;
import com.bcxin.tenant.open.infrastructures.events.EventDispatcher;
import com.bcxin.tenant.open.infrastructures.exceptions.ArgumentTenantException;
import com.bcxin.tenant.open.infrastructures.exceptions.DocumentIndexNoFoundException;
import com.bcxin.tenant.open.infrastructures.exceptions.RetryableTenantException;
import com.bcxin.tenant.open.infrastructures.utils.RetryUtil;
import com.bcxin.tenant.open.jdks.*;
import com.bcxin.tenant.open.jdks.requests.HotCacheRequest;
import com.bcxin.tenant.open.jdks.requests.SyncParameterWrapperRequest;
import com.redis.om.spring.search.stream.EntityStream;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;

@DubboService
public class RdSyncRpcWriterProviderImpl implements RdSyncRpcWriterProvider {
    private static final Logger logger = LoggerFactory.getLogger(RdSyncRpcWriterProviderImpl.class);
    private final EmployeeWriterRpcProvider employeeWriterRpcProvider;
    private final CompanyWriterRpcProvider companyWriterRpcProvider;
    private final SecurityStationWriterRpcProvider securityStationWriterRpcProvider;
    private final UnitWork unitWork;
    private final RdSyncDataRepository syncDataRepository;
    private final RdSyncStatusDocumentRepository syncStatusDocumentRepository;

    private final CommunityUserWriterRpcProvider communityUserWriterRpcProvider;

    private final ExamRoomRpcProvider examRoomRpcProvider;
    private final ExamSiteWriterRpcProvider examSiteRpcProvider;

    private final SystemExamInfoRpcProvider systemExamInfoRpcProvider;
    private final DispatchDataScopeRpcProvider dispatchDataScopeRpcProvider;
    private final EventDispatcher eventDispatcher;

    private final EntityStream entityStream;
    private final RdDispatchDataScopeDocumentRepository dispatchDataScopeDocumentRepository;

    private final ProjectWriterRpcProvider projectWriterRpcProvider;
    private final ThreadLocal<RdSyncStatusDocument> _currentSelectedSyncStatusDocumentLocal = new InheritableThreadLocal<>();
    private final DeviceWriterRpcProvider deviceWriterRpcProvider;
    private final HotCacheRpcProvider hotCacheRpcProvider;

    private final RefreshIndexComponent refreshIndexComponent;
	private final RetryProvider retryProvider;
    
    public RdSyncRpcWriterProviderImpl(EmployeeWriterRpcProvider employeeWriterRpcProvider,
                                       CompanyWriterRpcProvider companyWriterRpcProvider,
                                       SecurityStationWriterRpcProvider securityStationWriterRpcProvider,
                                       ExamRoomRpcProvider examRoomRpcProvider,
                                       ExamSiteWriterRpcProvider examSiteRpcProvider,
                                       SystemExamInfoRpcProvider systemExamInfoRpcProvider,
                                       UnitWork unitWork,
                                       RdSyncDataRepository syncDataRepository,
                                       RdSyncStatusDocumentRepository syncStatusDocumentRepository,
                                       CommunityUserWriterRpcProvider communityUserWriterRpcProvider,
                                       DispatchDataScopeRpcProvider dispatchDataScopeRpcProvider, EventDispatcher eventDispatcher,
                                       EntityStream entityStream, RdDispatchDataScopeDocumentRepository dispatchDataScopeDocumentRepository,
                                       ProjectWriterRpcProvider projectWriterRpcProvider, DeviceWriterRpcProvider deviceWriterRpcProvider,
                                       HotCacheRpcProvider hotCacheRpcProvider, RetryProvider retryProvider, RefreshIndexComponent refreshIndexComponent, RetryProvider retryProvider1) {
        this.employeeWriterRpcProvider = employeeWriterRpcProvider;
        this.companyWriterRpcProvider = companyWriterRpcProvider;
        this.securityStationWriterRpcProvider = securityStationWriterRpcProvider;
        this.examRoomRpcProvider = examRoomRpcProvider;
        this.examSiteRpcProvider = examSiteRpcProvider;
        this.systemExamInfoRpcProvider = systemExamInfoRpcProvider;
        this.unitWork = unitWork;
        this.syncDataRepository = syncDataRepository;
        this.syncStatusDocumentRepository = syncStatusDocumentRepository;
        this.communityUserWriterRpcProvider = communityUserWriterRpcProvider;
        this.dispatchDataScopeRpcProvider = dispatchDataScopeRpcProvider;
        this.eventDispatcher = eventDispatcher;
        this.entityStream = entityStream;
        this.dispatchDataScopeDocumentRepository = dispatchDataScopeDocumentRepository;
        this.projectWriterRpcProvider = projectWriterRpcProvider;
        this.deviceWriterRpcProvider = deviceWriterRpcProvider;
        this.refreshIndexComponent = refreshIndexComponent;
        this.retryProvider = retryProvider1;
         this.hotCacheRpcProvider = hotCacheRpcProvider;
        
    }

    @Override
    public void sync(SyncParameterWrapperRequest request ) {
        Collection<String> allIds = request.getIds();
        DispatchDataType dataType = request.getDataType();
        if (request.getDataType() == DispatchDataType.ProprietorStations && CollectionUtils.isEmpty(allIds)) {
            allIds =
                    this.entityStream.of(RdDispatchDataScopeDocument.class).map(RdDispatchDataScopeDocument::getId)
                            .collect(Collectors.toList());
        }

        if (CollectionUtils.isEmpty(allIds)) {
            logger.warn("执行刷新操作.无效数据({}): 集合数据不能为空:{}", dataType, allIds);
            return;
        }

        int pageSize = 800;
        int pageIndex = 1;
        Collection<String> ids = allIds.stream().skip((pageIndex - 1) * pageSize).limit(pageSize).collect(Collectors.toList());
        while (!CollectionUtils.isEmpty(ids)) {
            try {
                Collection<String> finalIds = ids;
                this.retryProvider.doExecute(()->{
                    this.unitWork.executeTran(()->{
                        this.syncDataRepository.reloadSyncData(SyncDataWrapperDTO.create(finalIds, dataType, request.getAdditionalParameter()));
                        if (request.isAutoUpdateExpired() && request.getDataType() == DispatchDataType.Station) {
                            this.syncDataRepository.reloadSyncData(
                                    SyncDataWrapperDTO.create(finalIds, DispatchDataType.ProprietorStations, request.getAdditionalParameter())
                            );
                        }
                    });

                    return true;
                });

            } catch (Exception ex) {
                logger.error("执行如下数据的时候发生异常:{},ids={}",
                        dataType, ids.stream().map(ix -> String.format("'%s'", ix))
                                .collect(Collectors.joining(",")));
                throw ex;
            }

            Collection<String> finalIds = ids;
            RetryUtil.execute(() -> {
                try {
                    executeUpdateDocument(dataType, finalIds, request);
                } catch (Exception ex) {
                    if (ex instanceof DocumentIndexNoFoundException) {
                        //todo: 抛出进行重试
                        this.refreshIndexComponent.execute(dataType);
                        throw new RetryableTenantException(ex.getMessage(), ex);
                    }

                    throw ex;
                }

            }, 3);

            pageIndex++;
            ids = allIds.stream().skip((pageIndex - 1) * pageSize).limit(pageSize).collect(Collectors.toList());
        }
    }

    public boolean checkIfAllowedSync(String topic, DispatchDataType dataType, Long maxTs, boolean isForRelativeChanged) {
        String idFromTopic = getSyncStatusDocumentId(topic, isForRelativeChanged);

        Optional<RdSyncStatusDocument> statusDocumentOptional =
                this.syncStatusDocumentRepository.findById(idFromTopic);
        if (!statusDocumentOptional.isPresent()) {
            return true;
        }

        RdSyncStatusDocument document = statusDocumentOptional.get();
        _currentSelectedSyncStatusDocumentLocal.set(document);
        if (document.getDataType().equals(dataType) && document.getTs() > maxTs) {
            logger.error("该主题({}-{})(dataType={})消息由于Ts太小, 预期(maxTs={})已经被消费过(已经被消费的Ts={},syncTime={}), 因此, 无法进行消费",
                    topic, isForRelativeChanged, dataType, maxTs, document.getTs(), document.getLastSyncTime()
            );

            return false;
        }

        return true;
    }

    public void commit(String topic, DispatchDataType dataType, Long offset, Long ts, Collection<String> ids, boolean isForRelativeChanged) {
        RdSyncStatusDocument document = _currentSelectedSyncStatusDocumentLocal.get();
        if (document == null) {
            document = new RdSyncStatusDocument();
        }

        document.setTopic(getSyncStatusDocumentId(topic, isForRelativeChanged));
        document.setTs(ts);
        document.setLastOffset(offset);
        document.setDataType(dataType);
        document.assignLastIds(ids);

        this.syncStatusDocumentRepository.save(document);
        _currentSelectedSyncStatusDocumentLocal.set(null);
    }

    @Override
    public Collection<String> getRelativeIds(ContentType contentType, int pageIndex, int pageSize) {
        return this.syncDataRepository.getRelativeIds(SyncDbCheckQueryDTO.create(contentType, pageIndex, pageSize));
    }

    private String getSyncStatusDocumentId(String topic, boolean isForRelativeChanged) {
        String idFromTopic = topic;
        if (isForRelativeChanged) {
            idFromTopic = String.format("%s-relativeChanged", topic);
        }

        return idFromTopic;
    }

    private void executeUpdateDocument(DispatchDataType dataType,Collection<String> ids,SyncParameterWrapperRequest request){
        switch (dataType) {
            case VideoDevice -> {
                Collection<String> attIds = (Collection<String>) request.getAdditionalParameter();
                if (!CollectionUtils.isEmpty(attIds)) {
                    this.securityStationWriterRpcProvider.flush2Redis(attIds);
                    this.examRoomRpcProvider.flush2Redis(attIds);
                }
            }
            case Company, RefreshCompanyDesks, RefreshCompanyPoints -> {
                this.companyWriterRpcProvider.flush2Redis(ids, dataType);
                if (dataType == DispatchDataType.Company) {
                    Collection<String> relativeOrgIds = (Collection<String>) request.getAdditionalParameter();
                    if (!CollectionUtils.isEmpty(relativeOrgIds)) {
                        this.eventDispatcher.dispatch(ProprietorCompanyChangedIntegrationEvent.create(relativeOrgIds));
                    }
                }
            }
            case Station -> {
                this.securityStationWriterRpcProvider.flush2Redis(ids);

                /**
                 * 定时更新过期驻勤点的时候; 顺便刷新内保管理的驻勤信息
                 */
                if (request.isAutoUpdateExpired()) {
                    this.syncDataRepository.clearExpiredProprietorStations(ids);
                    this.dispatchDataScopeRpcProvider.flush2Redis(ids, DispatchDataScopeType.Proprietor);
                }

                try {
                    ids.parallelStream().forEach(key -> {
                        HotCacheManager.remove(HotCacheManager.CacheDataType.SecurityStation, key);
                    });
                } catch (Exception ex) {
                    logger.error("清除驻勤点本地缓存发生异常:{}", ids == null ? "" : ids.stream().collect(Collectors.joining(",")), ex);
                }
            }
            case Employee, Member -> {
                this.employeeWriterRpcProvider.flush2Redis(ids, false);
            }

            case User -> {
                this.employeeWriterRpcProvider.flush2RedisByTenantUserIds(ids);
            }
            case ExamRoom -> {
                this.examRoomRpcProvider.flush2Redis(ids);
            }
            case ExamSite -> {
                this.examSiteRpcProvider.flush2Redis(ids);
            }
            case SystemExamInfo -> {
                this.systemExamInfoRpcProvider.flush2Redis(ids);
            }
            case CommunityUser -> {
                this.communityUserWriterRpcProvider.flush2Redis(ids);
            }
            case SuperviseDeparts -> {
                this.dispatchDataScopeRpcProvider.flush2Redis(ids,DispatchDataScopeType.Supervised);
            }
            case CompanyPermissions -> {
                this.dispatchDataScopeRpcProvider.flush2Redis(ids, DispatchDataScopeType.Company);
            }
            case EventOrganizerLimitedResource -> {
                this.dispatchDataScopeRpcProvider.flush2Redis(ids, DispatchDataScopeType.EventOrganizerLimitedResource);
            }
            case TemporaryProtectionProjectGroup,TemporaryProtectionProjectMember->{
                // 在kafka的订阅中; 它是通过累计的方式来实现刷新操作
            }
            case TemporaryProtectionProject -> {
                this.projectWriterRpcProvider.flush2Redis(ids);
            }
            case ProprietorStations -> {
                Collection<String> attIds = (Collection<String>) request.getAdditionalParameter();
                if (CollectionUtils.isEmpty(attIds)) {
                    throw new ArgumentTenantException("内保关联表取得的驻勤点Id无效");
                }

                this.dispatchDataScopeRpcProvider.flush2Redis(attIds,DispatchDataScopeType.Proprietor);
            }
            case Device,HareWareDevice -> {
                this.deviceWriterRpcProvider.flush2Redis(ids);
            }
            case DispatchDataSource -> {
                this.hotCacheRpcProvider.refresh(HotCacheRequest.create(HotCacheRequest.CacheCategory.DispatchDataSource, ids));
            }
        }
    }
}
