package com.bcxin.tenant.open.dubbo.writer.providers.impls;

import com.bcxin.tenant.open.domains.criterias.ProjectTeamMemberCriteria;
import com.bcxin.tenant.open.domains.repositories.RdProjectTeamMemberRepository;
import com.bcxin.tenant.open.infrastructures.EntityCollection;
import com.bcxin.tenant.open.infrastructures.exceptions.ArgumentTenantException;
import com.bcxin.tenant.open.jdks.ProjectTeamMemberRpcProvider;
import com.bcxin.tenant.open.jdks.requests.ProjectTeamMemberSearchRequest;
import com.bcxin.tenant.open.jdks.responses.ProjectTeamMemberResponse;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@DubboService
public class ProjectTeamMemberRpcProviderImpl implements ProjectTeamMemberRpcProvider {

    private final RdProjectTeamMemberRepository projectTeamMemberRepository;

    public ProjectTeamMemberRpcProviderImpl(RdProjectTeamMemberRepository projectTeamMemberRepository) {
        this.projectTeamMemberRepository = projectTeamMemberRepository;
    }

    @Override
    public EntityCollection<ProjectTeamMemberResponse> search(ProjectTeamMemberSearchRequest request) {
        if (!StringUtils.hasLength(request.getProjectId())) {
            throw new ArgumentTenantException("参数异常; 项目Id不能为空");
        }

        var data = this.projectTeamMemberRepository.search(ProjectTeamMemberCriteria.create(
                request.getPageIndex(),
                request.getPageSize(),
                request.getIdCardNo(),
                request.getPersonType(),
                request.getCompanyName(),
                request.getProjectId()
        ));

        return EntityCollection.create(
                data.getData().stream().map(
                        entity -> new ProjectTeamMemberResponse(
                                entity.getId(),
                                entity.getName(),
                                entity.getContact(),
                                entity.getPersonType(),
                                entity.getOrganizationId(),
                                entity.getCompanyName(),
                                entity.getIdCardNo(),
                                entity.getSex()
                        )
                ).toList(),
                data.getPageSize(),
                data.getTotalCount()
        );
    }
}
