package com.bcxin.tenant.open.dubbo.writer.providers.impls;

import com.bcxin.tenant.open.domains.services.OrgPurseTransactionService;
import com.bcxin.tenant.open.domains.services.commands.RechargeOrgPurseTransactionCommand;
import com.bcxin.tenant.open.jdks.OrgPurseTransactionRpcProvider;
import com.bcxin.tenant.open.jdks.requests.OrgPurseTransactionBillRequest;
import org.apache.dubbo.config.annotation.DubboService;

@DubboService
public class OrgPurseTransactionRpcProviderImpl implements OrgPurseTransactionRpcProvider {
    private OrgPurseTransactionService orgPurseTransactionService;

    public OrgPurseTransactionRpcProviderImpl(OrgPurseTransactionService orgPurseTransactionService) {
        this.orgPurseTransactionService = orgPurseTransactionService;
    }

    @Override
    public void chargeBills(OrgPurseTransactionBillRequest request) {
        orgPurseTransactionService.monthlyBillCharge(RechargeOrgPurseTransactionCommand.create(request.getOrganizationIds()));
    }
}
