package com.bcxin.tenant.open.dubbo.writer.providers.impls;

import com.bcxin.tenant.open.document.domains.documents.OrgPurseDocument;
import com.bcxin.tenant.open.document.domains.repositories.OrgPurseDocumentRepository;
import com.bcxin.tenant.open.domains.repositories.OrgPurseRepository;
import com.bcxin.tenant.open.domains.services.OrgPurseService;
import com.bcxin.tenant.open.domains.services.commands.RefreshOrgPurseCacheCommand;
import com.bcxin.tenant.open.dubbo.writer.providers.translates.DataTranslate;
import com.bcxin.tenant.open.infrastructures.utils.StringUtil;
import com.bcxin.tenant.open.jdks.OrgPurseRpcProvider;
import com.bcxin.tenant.open.jdks.requests.OrgPursePointRequest;
import com.bcxin.tenant.open.jdks.responses.OrgPurseValidateResponse;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Collection;
import java.util.stream.Collectors;

@DubboService
public class OrgPurseRpcProviderImpl implements OrgPurseRpcProvider {
    private static final Logger logger = LoggerFactory.getLogger(OrgPurseRpcProviderImpl.class);

    private final OrgPurseRepository orgPurseRepository;
    private final DataTranslate dataTranslate;

    private final OrgPurseDocumentRepository orgPurseDocumentRepository;
    private final OrgPurseService orgPurseService;

    public OrgPurseRpcProviderImpl(OrgPurseRepository orgPurseRepository, DataTranslate dataTranslate,
                                   OrgPurseDocumentRepository orgPurseDocumentRepository, OrgPurseService orgPurseService) {
        this.orgPurseRepository = orgPurseRepository;
        this.dataTranslate = dataTranslate;
        this.orgPurseDocumentRepository = orgPurseDocumentRepository;
        this.orgPurseService = orgPurseService;
    }

    @Override
    public OrgPurseValidateResponse validate(OrgPursePointRequest request) {
        assert request != null || !CollectionUtils.isEmpty(request.getOrganizationIds());

        Collection<OrgPurseDocument> documents =
                this.orgPurseDocumentRepository.findAllById(request.getOrganizationIds());
        if (request.getOrganizationIds().stream().anyMatch(ii -> !documents.stream().anyMatch(ix -> StringUtil.isEqual(ix.getId(), ii)))) {
            Collection<String> notExistsOrganizationIds
                    = request.getOrganizationIds().stream()
                    .filter(ii -> !documents.stream().anyMatch(ix -> StringUtil.isEqual(ix.getId(), ii)))
                    .collect(Collectors.toList());

            Collection<OrgPurseDocument> translateDocuments =
                    orgPurseService.dispatch(RefreshOrgPurseCacheCommand.create(notExistsOrganizationIds, false));
            documents.addAll(translateDocuments);
        }

        OrgPurseValidateResponse response =
                this.dataTranslate.translate2OrgPurses(request, documents);

        return response;
    }
}
