package com.bcxin.tenant.open.dubbo.writer.providers.impls;

import com.bcxin.tenant.open.domains.services.MonthlyBillService;
import com.bcxin.tenant.open.domains.services.commands.GenerateMonthlyBillCommand;
import com.bcxin.tenant.open.jdks.MonthlyBillRpcProvider;
import com.bcxin.tenant.open.jdks.requests.MonthlyBillWriteRequest;
import org.apache.dubbo.config.annotation.DubboService;

@DubboService
public class MonthlyBillRpcProviderImpl implements MonthlyBillRpcProvider {
    private MonthlyBillService monthlyBillService;

    public MonthlyBillRpcProviderImpl(MonthlyBillService monthlyBillService){
        this.monthlyBillService = monthlyBillService;
    }
    @Override
    public void billsGenerate(MonthlyBillWriteRequest request) {
        this.monthlyBillService.dispatch(GenerateMonthlyBillCommand.create(request.getDate(),request.getBillTypes()));
    }
}
