package com.bcxin.tenant.open.dubbo.writer.providers.impls;

import com.bcxin.tenant.open.document.domains.documents.RdDeviceDeskPermissionDocument;
import com.bcxin.tenant.open.document.domains.documents.RdDispatchDataScopeDocument;
import com.bcxin.tenant.open.document.domains.documents.RdEmployeeDocument;
import com.bcxin.tenant.open.document.domains.repositories.RdDeviceDeskPermissionDocumentRepository;
import com.bcxin.tenant.open.document.domains.repositories.RdDispatchDataScopeDocumentRepository;
import com.bcxin.tenant.open.document.domains.repositories.RdEmployeeDocumentRepository;
import com.bcxin.tenant.open.domains.entities.RdDispatchDataScopeEntity;
import com.bcxin.tenant.open.domains.entities.RdDispatchDataSourceEntity;
import com.bcxin.tenant.open.domains.readers.RdCompositedReader;
import com.bcxin.tenant.open.domains.repositories.RdDispatchDataScopeRepository;
import com.bcxin.tenant.open.domains.views.RdDeviceDeskServiceScopeView;
import com.bcxin.tenant.open.dubbo.writer.providers.translates.DataTranslate;
import com.bcxin.tenant.open.infrastructures.configs.TenantSystemConfig;
import com.bcxin.tenant.open.infrastructures.enums.DispatchAccountType;
import com.bcxin.tenant.open.infrastructures.enums.DispatchDataScopeType;
import com.bcxin.tenant.open.infrastructures.enums.RoleType;
import com.bcxin.tenant.open.infrastructures.utils.BusinessUtil;
import com.bcxin.tenant.open.infrastructures.utils.StringUtil;
import com.bcxin.tenant.open.jdks.IdentityRpcProvider;
import com.bcxin.tenant.open.infrastructures.UserDetailResponse;
import com.bcxin.tenant.open.infrastructures.enums.DispatchDataType;
import com.bcxin.tenant.open.jdks.RdSyncRpcWriterProvider;
import com.bcxin.tenant.open.jdks.requests.SyncParameterWrapperRequest;
import com.bcxin.tenant.open.jdks.responses.RdDeviceDeskPermissionResponse;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.*;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@DubboService
public class IdentityRpcProviderImpl implements IdentityRpcProvider {
    private static final Logger logger = LoggerFactory.getLogger(IdentityRpcProviderImpl.class);
    private final RdCompositedReader compositedReader;
    private final RdEmployeeDocumentRepository employeeDocumentRepository;
    private final RdDeviceDeskPermissionDocumentRepository deviceDeskPermissionDocumentRepository;
    private final DataTranslate dataTranslate;
    private final RdDispatchDataScopeDocumentRepository dispatchDataScopeDocumentRepository;
    private final RdSyncRpcWriterProvider syncRpcWriterProvider;

    private final TenantSystemConfig tenantSystemConfig;
    private final RdDispatchDataScopeRepository dispatchDataScopeRepository;

    public IdentityRpcProviderImpl(RdCompositedReader compositedReader,
                                   RdEmployeeDocumentRepository employeeDocumentRepository,
                                   RdDeviceDeskPermissionDocumentRepository deviceDeskPermissionDocumentRepository,
                                   DataTranslate dataTranslate,
                                   RdDispatchDataScopeDocumentRepository dispatchDataScopeDocumentRepository,TenantSystemConfig tenantSystemConfig,RdSyncRpcWriterProvider syncRpcWriterProvider, RdDispatchDataScopeRepository dispatchDataScopeRepository) {
        this.compositedReader = compositedReader;
        this.employeeDocumentRepository = employeeDocumentRepository;
        this.deviceDeskPermissionDocumentRepository = deviceDeskPermissionDocumentRepository;
        this.dataTranslate = dataTranslate;
        this.dispatchDataScopeDocumentRepository = dispatchDataScopeDocumentRepository;
        this.syncRpcWriterProvider = syncRpcWriterProvider;
        this.tenantSystemConfig = tenantSystemConfig;
        this.dispatchDataScopeRepository = dispatchDataScopeRepository;
    }

    @Override
    public UserDetailResponse getByEmployeeId(String employeeId, DispatchAccountType accountType) {
        RdEmployeeDocument employeeDocument =
                this.employeeDocumentRepository.findById(employeeId)
                        .orElse(null);
        if (employeeDocument == null) {
            synchronized (IdentityRpcProviderImpl.class) {
                this.syncRpcWriterProvider.sync(SyncParameterWrapperRequest.create(DispatchDataType.Employee, Collections.singleton(employeeId)));
                employeeDocument = this.employeeDocumentRepository.findById(employeeId)
                        .orElse(null);

                if (employeeDocument == null) {
                    /**
                     * 再次刷新的Member的数据, 来解决
                     */
                    this.syncRpcWriterProvider.sync(SyncParameterWrapperRequest.create(DispatchDataType.Member, Collections.singleton(employeeId)));

                    employeeDocument = this.employeeDocumentRepository.findById(employeeId)
                            .orElse(null);
                }

                logger.error("降级: 异常信息: 该请求来自于强制再次刷新用户({})数据到redis中.", employeeId);
            }

            if (employeeDocument == null) {
                return null;
            }
        }

        //todo 确认下这个是否可用
        UserDetailResponse response = UserDetailResponse.create(
                employeeDocument.getTenantUserId(),
                employeeDocument.getTenantEmployeeId(),
                employeeDocument.getName(),
                employeeDocument.getOrganizationId(),
                employeeDocument.getOccupationType(),
                employeeDocument.getTenantImUserId(),
                accountType,
                employeeDocument.getInstitutional(),
                employeeDocument.getSuperviseRegionCode(),
                employeeDocument.getCompanyName(),
                employeeDocument.isDomainAdmin(),
                /**
                 * 我负责的驻勤信息
                 * todo: 2024-12-14 这边还要能够添加负责的所有岗点: 比如: 马拉松的承办单位等.
                 * 但是承办单位的权限还是需要做实时获取比较适合(缓存并及时清理)
                 */
                employeeDocument.getResponsibleOfStationIds(),
                employeeDocument.getSecurityStationId() == null ? null : Stream.of(employeeDocument.getSecurityStationId()).collect(Collectors.toList()),
                employeeDocument.getCLevel(),
                employeeDocument.getResourceTypes(),
                employeeDocument.getPaymentOrgId()
        );

        return response;
    }

    @Override
    public RdDeviceDeskPermissionResponse getDeviceDeskPermission(String employeeId,String organizationId,
                                                                  DispatchAccountType accountType,
                                                                  String orgInstitutional,
                                                                  String orgName,
                                                                  String orgId) {
        RdDeviceDeskPermissionDocument document =
                this.deviceDeskPermissionDocumentRepository.findById(employeeId).orElse(null);

        if(document==null) {
            document = getMergedDeviceDeskPermission(
                    Collections.singleton(employeeId), accountType, orgInstitutional, orgName,
                    orgId);
            if (document == null) {
                return null;
            }
        }

        RdDeviceDeskPermissionResponse response = this.dataTranslate.translate(document);

        if (response == null || CollectionUtils.isEmpty(response.getServiceScopes())) {
            return response;
        }

        Collection<RdDeviceDeskPermissionResponse.RdDeviceDeskServiceScopeResponse> serviceScopeResponses =
                response.getServiceScopes().stream()
                        /**
                         * 这边判断为空是为了兼容旧数据, 再次版本之前, 这个对象是没有存储organizationId, 因此, 都是本公司的数据
                         */
                        .filter(ii -> BusinessUtil.isExpectedOrganization(organizationId,ii.getOrganizationId()))
                        .collect(Collectors.toList());

        return RdDeviceDeskPermissionResponse.create(serviceScopeResponses);
    }

    @Override
    public RdDeviceDeskPermissionResponse getMergedDeviceDeskPermission(
            String tenantUserId,
            String employeeId,
            boolean isSupervise,
            DispatchAccountType accountType,
            String orgInstitutional,
            String orgName,
            String orgId

    ) {
        Optional<RdDeviceDeskPermissionDocument> deviceDeskPermissionDocumentOptional =
                this.deviceDeskPermissionDocumentRepository.findById(employeeId);

        RdDeviceDeskPermissionDocument document = null;
        if (!deviceDeskPermissionDocumentOptional.isPresent() ||
                CollectionUtils.isEmpty(deviceDeskPermissionDocumentOptional.get().getServiceScopes())
        ) {

            Collection<String> selectedEmployeeIds = Collections.singleton(employeeId);
            /**
             * 如果是监管端, 那么允许它查询跨公司的数据
             *
             * 无须进行派出所的调度台权限合并, 因为人口等信息是不会有调度台的.
             * 20240428
             */
            /*
            if (isSupervise) {
                Collection<RdEmployeeDocument> employeeDocuments =
                        this.employeeDocumentRepository.findByTenantUserId(tenantUserId);
                Collection<RoleType> policeStationRoleTypes = new HashSet<>();
                policeStationRoleTypes.add(RoleType.PoliceStation);
                policeStationRoleTypes.add(RoleType.PopulationPoliceStation);

                Collection<String> matchedCrossesEmployeeIds = employeeDocuments.stream()
                        .filter(ii -> policeStationRoleTypes.contains(RoleType.create(ii.getInstitutional(), ii.getCompanyName())))
                        .map(ii -> ii.getTenantEmployeeId()).collect(Collectors.toSet());
                matchedCrossesEmployeeIds.add(employeeId);

                selectedEmployeeIds = matchedCrossesEmployeeIds;
            }
             */
            document = getMergedDeviceDeskPermission(selectedEmployeeIds, accountType, orgInstitutional, orgName,orgId);
        } else {
            document = deviceDeskPermissionDocumentOptional.get();
        }

        return this.dataTranslate.translate(document);
    }

    /**
     * 这边的employeeIds必须是对应于同一个用户
     * @param employeeIds
     * @return
     */
    private RdDeviceDeskPermissionDocument getMergedDeviceDeskPermission(Collection<String> employeeIds,
                                                                         DispatchAccountType accountType,
                                                                         String orgInstitutional,
                                                                         String orgName,
                                                                         String orgId
                                                                         ) {
        if (CollectionUtils.isEmpty(employeeIds)) {
            return null;
        }

        Collection<RdDeviceDeskServiceScopeView> deviceDeskServiceScopes = new ArrayList<>();
        if(!tenantSystemConfig.isSuperiorSystem())
        {
            deviceDeskServiceScopes = this.compositedReader.getByEmployeeIds(employeeIds);
        }else {
            deviceDeskServiceScopes = this.compositedReader.getSuperiorDeskByBoundEmployeeIds(employeeIds);
        }

        if (!CollectionUtils.isEmpty(deviceDeskServiceScopes)) {
            Collection<RdDeviceDeskPermissionDocument.RdDeviceDeskServiceScopeValueType>
                    deviceDeskServiceScopeResponses =
                    deviceDeskServiceScopes.stream().map(ii ->
                            RdDeviceDeskPermissionDocument.RdDeviceDeskServiceScopeValueType.create(
                                    ii.getId(),
                                    ii.getName(),
                                    ii.getNumber(),
                                    ii.getBeginDate(),
                                    ii.getEndDate(),
                                    ii.getBoundEmployeeId(),
                                    ii.getAssignedSuperviseDepartId(),
                                    ii.getIpAddress(),
                                    ii.getOrganizationId(),
                                    ii.getDescription()
                            )).collect(Collectors.toList());

            RoleType currentRoleType = RoleType.create(orgInstitutional,orgName);

            RdDispatchDataScopeEntity dataScopeEntity =
            this.dispatchDataScopeRepository.getById(String.format("%s_%s",  DispatchDataScopeType.AssignedOrgPermissionResources.getValue(), orgId));
            if(dataScopeEntity!=null && !StringUtil.isEmpty(dataScopeEntity.getScope())) {
                Collection<String> assignedPermissions =
                        Arrays.stream(dataScopeEntity.getScope().split(","))
                                .filter(ii ->
                                        !deviceDeskServiceScopeResponses.stream().anyMatch(ix -> StringUtil.isEqual(ix.getAssignedSuperviseDepartId(), ii)))
                                .collect(Collectors.toList());
                /**
                 * Copy这些不存在的组织Id
                 */
                RdDeviceDeskPermissionDocument.RdDeviceDeskServiceScopeValueType firstCopyOne =
                        deviceDeskServiceScopeResponses.stream().findFirst().orElse(null);
                if (firstCopyOne != null) {
                    Collection<RdDeviceDeskPermissionDocument.RdDeviceDeskServiceScopeValueType> addedPermissions
                            = assignedPermissions.stream().map(ii ->
                            firstCopyOne.copy(ii, false, "AssignedOrgPermissionResources")
                    ).collect(Collectors.toList());
                    deviceDeskServiceScopeResponses.addAll(addedPermissions);
                }
            }

            /**
             * 仅监管的派出所合并人口+内保+保安的调度数据（因为派出所只有一个）
             */
            if(currentRoleType==RoleType.PoliceStation ||
                    currentRoleType==RoleType.PopulationPoliceStation) {
                Collection<String> superviseDepartIds =
                        deviceDeskServiceScopeResponses.stream()
                                .map(ii -> ii.getAssignedSuperviseDepartId())
                                .filter(ii -> StringUtils.hasLength(ii))
                                .distinct().collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(superviseDepartIds)) {
                    Collection<RdDispatchDataScopeDocument> dataScopeDocuments =
                            this.dispatchDataScopeDocumentRepository.findAllById(superviseDepartIds);
                    for (RdDispatchDataScopeDocument dd : dataScopeDocuments) {
                        if (!CollectionUtils.isEmpty(dd.getScopes())) {
                            RdDeviceDeskPermissionDocument.RdDeviceDeskServiceScopeValueType selectedDeskServiceScope =
                                    deviceDeskServiceScopeResponses.stream()
                                            .filter(ix -> StringUtil.isEqual(ix.getAssignedSuperviseDepartId(), dd.getId()))
                                            .findFirst().orElse(null);
                            if (selectedDeskServiceScope == null) {
                                logger.error("系统异常: 调度台的数据范围不应该为空:id={};scope={};type={}", dd.getId(), dd.getScopes(), dd.getScopeType());
                            } else {
                                deviceDeskServiceScopeResponses.addAll(
                                        dd.getScopes().stream()
                                                .filter(ii -> StringUtils.hasLength(ii))
                                                .map(ix -> selectedDeskServiceScope.copy(ix,true,null))
                                                .collect(Collectors.toList())
                                );
                            }
                        }
                    }
                }
            }

            Collection<String> matchedEmployeeIds =
                    deviceDeskServiceScopes
                            .stream().map(ii -> ii.getBoundEmployeeId())
                            .distinct()
                            .collect(Collectors.toList());

            Collection<String> responsibleOfStationIds = new HashSet<>();
            if (accountType == DispatchAccountType.AppDesk) {
                RoleType roleType = RoleType.create(orgInstitutional, orgName);
                /**
                 * 针对派出所以及群防群治及保安企业的驻勤点负责人的限制
                 **/
                if (roleType == RoleType.PoliceStation || roleType == RoleType.PopulationPoliceStation || roleType == RoleType.Company) {
                    Collection<RdEmployeeDocument> selectedEmployeeDocuments =
                            employeeDocumentRepository.findAllById(employeeIds);
                    responsibleOfStationIds = selectedEmployeeDocuments.stream()
                            /**
                             * 针对组织管理员和非驻勤负责人; 不限制调度范围
                             * //组织管理则不限制
                             */
                            .filter(ii -> ii.getResponsibleOfStationIds() != null && (!ii.isDomainAdmin() || "06".equalsIgnoreCase(ii.getInstitutional())))
                            .flatMap(ix -> ix.getResponsibleOfStationIds().stream())
                            .collect(Collectors.toSet());

                    /**
                     * 社区警务
                     */
                    if (CollectionUtils.isEmpty(responsibleOfStationIds) &&
                            (roleType == RoleType.PoliceStation || roleType == RoleType.PopulationPoliceStation)
                    ) {
                        //针对社区警务的人员; 如果不是驻勤点负责人的话, 则不允许查看社区警务及人员
                        if (selectedEmployeeDocuments.stream().anyMatch(ix -> "06".equalsIgnoreCase(ix.getIndustry()))) {
                            responsibleOfStationIds = Collections.singleton("#NOT_ALLOWED_ACCESS");
                        }
                    }
                }
            }

            Collection<String> finalResponsibleOfStationIds = responsibleOfStationIds;
            Collection<RdDeviceDeskPermissionDocument> deskPermissionDocuments =
                    matchedEmployeeIds.stream().map(ii -> {
                        return RdDeviceDeskPermissionDocument.create(ii,
                                finalResponsibleOfStationIds,
                                deviceDeskServiceScopeResponses);
                    }).collect(Collectors.toList());

            /**
             * todo: 赛演项目管理单位对应的岗点信息;
             * 管理单位: 默认拥有参与项目的所有权限或者指定的权限
             */

            this.deviceDeskPermissionDocumentRepository.saveAll(deskPermissionDocuments);

            return deskPermissionDocuments.stream().findFirst().get();
        } else {
            return null;
        }
    }
}
