package com.bcxin.tenant.open.dubbo.writer.providers.impls;

import com.bcxin.tenant.open.document.domains.documents.RdExamSiteRoomDocument;
import com.bcxin.tenant.open.document.domains.repositories.RdExamSiteRoomDocumentRepository;
import com.bcxin.tenant.open.domains.entities.RdExamSiteRoomEntity;
import com.bcxin.tenant.open.domains.entities.StationDeviceEntity;
import com.bcxin.tenant.open.domains.repositories.RdExamSiteRoomRepository;
import com.bcxin.tenant.open.domains.repositories.StationDeviceRepository;
import com.bcxin.tenant.open.dubbo.writer.providers.translates.DataTranslate;
import com.bcxin.tenant.open.jdks.ExamRoomRpcProvider;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Function;
import java.util.stream.Collectors;

@DubboService
public class ExamRoomRpcProviderImpl implements ExamRoomRpcProvider {
    private static final Logger logger = LoggerFactory.getLogger(ExamRoomRpcProviderImpl.class);
    private static final int PAGE_SIZE=500;
    private final RdExamSiteRoomDocumentRepository rdExamSiteRoomDocumentRepository;
    private final RdExamSiteRoomRepository rdExamSiteRoomRepository;
    private final DataTranslate dataTranslate;

    private final StationDeviceRepository stationDeviceRepository;

    public ExamRoomRpcProviderImpl(RdExamSiteRoomDocumentRepository rdExamSiteRoomDocumentRepository,
                                   RdExamSiteRoomRepository rdExamSiteRoomRepository,
                                   DataTranslate dataTranslate, StationDeviceRepository stationDeviceRepository) {
        this.rdExamSiteRoomDocumentRepository = rdExamSiteRoomDocumentRepository;
        this.rdExamSiteRoomRepository = rdExamSiteRoomRepository;
        this.dataTranslate = dataTranslate;
        this.stationDeviceRepository = stationDeviceRepository;
    }

    @Override
    public int flush2Redis(Collection<String> ids) {
        return doExecuteFlush(pageIndex -> {
                    return this.rdExamSiteRoomRepository.getByPage(ids, pageIndex, PAGE_SIZE);
                }, ids);
    }

    private int doExecuteFlush(Function<Integer, Collection<RdExamSiteRoomEntity>> extractExamSiteRooms,Collection<String> ids) {
        int pageIndex = 1;
        int totalCount = 0;

        Collection<RdExamSiteRoomEntity> examSiteRoomEntities = extractExamSiteRooms.apply(pageIndex);

        Collection<String> notExistsIds = new ArrayList<>();
        if (!CollectionUtils.isEmpty(ids)) {
            notExistsIds = ids.stream().toList();
        }

       Collection<StationDeviceEntity> stationDevices = this.stationDeviceRepository.getByStationIds(ids);

        while (!CollectionUtils.isEmpty(examSiteRoomEntities)) {
            if (!CollectionUtils.isEmpty(notExistsIds)) {
                Collection<String> existsIds = examSiteRoomEntities.stream().map(ii -> ii.getId()).collect(Collectors.toList());
                /**
                 * 使用Remove会抛null异常
                 */
                notExistsIds = notExistsIds.stream().filter(ii -> !existsIds.contains(ii)).collect(Collectors.toList());
            }

            Collection<RdExamSiteRoomDocument> documents =
                    this.dataTranslate.translate2ExamSiteRooms(examSiteRoomEntities);

            if (CollectionUtils.isEmpty(documents)) {
                return totalCount;
            }


            Collection<RdExamSiteRoomDocument> deletedDocuments
                    = documents.stream()
                    .filter(ii -> !ii.isStatus()).collect(Collectors.toList());

            Collection<RdExamSiteRoomDocument> updatedDocuments
                    = documents.stream().filter(ii -> ii.isStatus()).collect(Collectors.toList());

            if (deletedDocuments != null && !deletedDocuments.isEmpty()) {
                this.rdExamSiteRoomDocumentRepository.deleteAll(deletedDocuments);
                logger.error("删除如下考场信息内容:{};",
                        deletedDocuments.stream()
                                .map(ix -> ix.getId()).collect(Collectors.joining(";"))
                );
            }

            for(RdExamSiteRoomDocument document :updatedDocuments) {
                document.setHasVideo(false);

                if (!CollectionUtils.isEmpty(stationDevices)) {
                    document.setHasVideo(stationDevices.stream().anyMatch(ix -> document.getId().equalsIgnoreCase(ix.getStationId())));
                }
            }

            this.rdExamSiteRoomDocumentRepository.saveAll(updatedDocuments);

            totalCount += documents.size();
            pageIndex++;
            if (documents.size() < PAGE_SIZE) {
                break;
            }

            examSiteRoomEntities = extractExamSiteRooms.apply(pageIndex);

        }

        /**
         * 清除不在需要的文档
         */
        if (!CollectionUtils.isEmpty(notExistsIds)) {
            this.rdExamSiteRoomDocumentRepository.deleteAllById(notExistsIds);
        }

        return totalCount;
    }
}
