package com.bcxin.tenant.open.dubbo.writer.providers.impls;

import com.bcxin.tenant.open.domains.entities.RdDynamicStationTypeEntity;
import com.bcxin.tenant.open.domains.repositories.RdDynamicStationTypeRepository;
import com.bcxin.tenant.open.infrastructures.TenantContext;
import com.bcxin.tenant.open.infrastructures.TenantEmployeeContext;
import com.bcxin.tenant.open.infrastructures.components.JsonProvider;
import com.bcxin.tenant.open.infrastructures.valueTypes.StationCodeValueType;
import com.bcxin.tenant.open.jdks.DynamicStationTypeWriterRpcProvider;
import org.apache.dubbo.config.annotation.DubboService;

import java.util.Collection;
import java.util.stream.Collectors;

@DubboService
public class DynamicStationTypeWriterRpcProviderImpl implements DynamicStationTypeWriterRpcProvider {
    private final RdDynamicStationTypeRepository dynamicStationTypeRepository;
    private final JsonProvider jsonProvider;

    public DynamicStationTypeWriterRpcProviderImpl(RdDynamicStationTypeRepository dynamicStationTypeRepository, JsonProvider jsonProvider) {
        this.dynamicStationTypeRepository = dynamicStationTypeRepository;
        this.jsonProvider = jsonProvider;
    }

    @Override
    public Collection<StationCodeValueType> getAll() {
        TenantEmployeeContext.TenantUserModel userModel = TenantContext.getInstance().getUserContext().get();
        Collection<RdDynamicStationTypeEntity> entities =
                this.dynamicStationTypeRepository.getAll(userModel.getOrganizationId());

        return entities.stream().map(ii -> StationCodeValueType.create(
                        jsonProvider, ii.getId(), ii.getName(), ii.getMapIcon(), ii.getIcon(), ii.getParticipatorOfflineIcon(), ii.getParticipatorIcon()))
                .collect(Collectors.toList());
    }
}
