package com.bcxin.tenant.open.dubbo.writer.providers.impls;

import com.bcxin.tenant.open.domains.entities.RdDispatchDataSourceEntity;
import com.bcxin.tenant.open.domains.repositories.RdDispatchDataSourceRepository;
import com.bcxin.tenant.open.jdks.DispatchDataSourceRpcProvider;
import com.bcxin.tenant.open.jdks.responses.DispatchDataSourceResponse;
import org.apache.dubbo.config.annotation.DubboService;

@DubboService
public class DispatchDataSourceRpcProviderImpl implements DispatchDataSourceRpcProvider {

    private final RdDispatchDataSourceRepository dispatchDataSourceRepository;

    public DispatchDataSourceRpcProviderImpl(RdDispatchDataSourceRepository dispatchDataSourceRepository) {
        this.dispatchDataSourceRepository = dispatchDataSourceRepository;
    }

    @Override
    public DispatchDataSourceResponse getById(String id) {
        RdDispatchDataSourceEntity dispatchDataSource = this.dispatchDataSourceRepository.getById(id);
        if (dispatchDataSource == null) {
            return null;
        }

        return DispatchDataSourceResponse.create(dispatchDataSource.getId(), dispatchDataSource.getName());
    }
}
