package com.bcxin.tenant.open.dubbo.writer.providers.impls;

import com.bcxin.tenant.open.domains.entities.DepartmentlevelEntity;
import com.bcxin.tenant.open.domains.repositories.DepartmentlevelRepository;
import com.bcxin.tenant.open.infrastructures.TenantContext;
import com.bcxin.tenant.open.infrastructures.TenantEmployeeContext;
import com.bcxin.tenant.open.infrastructures.enums.RoleType;
import com.bcxin.tenant.open.infrastructures.utils.BusinessUtil;
import com.bcxin.tenant.open.infrastructures.utils.StringUtil;
import com.bcxin.tenant.open.jdks.DepartmentlevelRpcProvider;
import com.bcxin.tenant.open.jdks.requests.DepartmentSearchRequest;
import com.bcxin.tenant.open.jdks.responses.DepartmentlevelHierarchyResponse;
import com.google.common.collect.Lists;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.*;
import java.util.stream.Collectors;

/**
 * 监管机构
 */
@DubboService
public class DepartmentlevelRpcProviderImpl implements DepartmentlevelRpcProvider {
    private static final Logger logger = LoggerFactory.getLogger(DepartmentlevelRpcProviderImpl.class);
    private final DepartmentlevelRepository departmentlevelRepository;

    public DepartmentlevelRpcProviderImpl(DepartmentlevelRepository departmentlevelRepository) {
        this.departmentlevelRepository = departmentlevelRepository;
    }

    @Override
    public Collection<DepartmentlevelHierarchyResponse> search(DepartmentSearchRequest request) {
        TenantEmployeeContext.TenantUserModel tenantUserModel =
                TenantContext.getInstance().getUserContext().get();

        if (!tenantUserModel.isSuperviseDepartRole()) {
            return Collections.EMPTY_LIST;
        }

        /**
         * 只显示直属管辖的派出所信息
         */

        if(CollectionUtils.isEmpty(tenantUserModel.getDeviceDeskServiceScopes())) {
            return Collections.EMPTY_LIST;
        }

        Collection<String> validSuperviseDepartIds =
                Arrays.stream(tenantUserModel.getAssignedSuperviseDepartIds()).collect(Collectors.toSet());
        Collection<String> superDisableDepartIds = tenantUserModel.getDeviceDeskServiceScopes()
                .stream().filter(ix ->
                        StringUtils.hasLength(ix.getAssignedSuperviseDepartId()) &&
                                validSuperviseDepartIds.contains(ix.getAssignedSuperviseDepartId())
                                && ix.getIr() == 0)
                .map(ii -> ii.getAssignedSuperviseDepartId())
                .collect(Collectors.toSet());

        Collection<DepartmentlevelEntity> all =
                this.departmentlevelRepository.getAllByIds(superDisableDepartIds);

        if(CollectionUtils.isEmpty(all)) {
            return Collections.EMPTY_LIST;
        }

        Collection<DepartmentlevelHierarchyResponse> responses =
                all.stream().filter(ii -> ii.getSuperior() == null)
                        .map(ii -> DepartmentlevelHierarchyResponse.create(
                                ii.getId(), ii.getName(), ii.getSuperior(),ii.getIndexCode(), null,true)
                        )
                        .collect(Collectors.toList());

        Collection<String> processedIds = new ArrayList<>();
        responses = buildChildHierarchyResponses(responses, all,processedIds);

        Collection<DepartmentlevelHierarchyResponse> finalResponses = responses;
        Collection<DepartmentlevelEntity> notMatchData =
                all.stream()
                        .filter(ii -> !finalResponses.stream().anyMatch(ir -> ir.contain(ii.getId())))
                        .collect(Collectors.toList());
        notMatchData =
                notMatchData.stream()
                        .sorted(Comparator.comparing(DepartmentlevelEntity::getIndexCode))
                        .collect(Collectors.toList());

        for (DepartmentlevelEntity ii : notMatchData) {
            if (!responses.stream().anyMatch(re -> re.contain(ii.getId()))) {
                DepartmentlevelHierarchyResponse item =
                        DepartmentlevelHierarchyResponse.create(
                                ii.getId(), ii.getName(), ii.getSuperior(), ii.getIndexCode(), null, false);

                addChildHierarchyResponses(item, notMatchData, processedIds);

                responses.add(item);
            }
        }

        return responses;
    }

    private Collection<DepartmentlevelHierarchyResponse> buildChildHierarchyResponses(Collection<DepartmentlevelHierarchyResponse> responses,
                                                                                      Collection<DepartmentlevelEntity> all,
                                                                                      Collection<String> processedIds) {
        for (DepartmentlevelHierarchyResponse item : responses) {
            this.addChildHierarchyResponses(item, all,processedIds);
        }

        return responses;
    }

    private DepartmentlevelHierarchyResponse addChildHierarchyResponses(
            DepartmentlevelHierarchyResponse item,
            Collection<DepartmentlevelEntity> all,
            Collection<String> processedIds) {
        if (item == null) {
            return null;
        }

        if (item.getCode() == null) {
            return null;
        }
        processedIds.add(item.getCode());

        Collection<DepartmentlevelHierarchyResponse> child
                = all.stream().filter(ii -> ii != null && !processedIds.contains(ii.getId()))
                .filter(ii -> !StringUtil.isEmpty(ii.getSuperior()) && ii.getSuperior().equalsIgnoreCase(item.getCode()))
                .map(ii -> DepartmentlevelHierarchyResponse.create(ii.getId(), ii.getName(), ii.getSuperior(), ii.getIndexCode(), null, false))
                .collect(Collectors.toList());

        logger.warn("正在递归执行的数据:name={};code={}",
                item.getName(),
                item.getCode(),
                "child={}", child.stream().map(ii ->
                        String.format("code=%s;name=%s;superior=%s", ii.getCode(), ii.getName(), ii.getSuperior())).collect(Collectors.joining()));
        child.forEach(ii -> {
            processedIds.add(ii.getCode());
            this.addChildHierarchyResponses(ii, all, processedIds);
        });

        processedIds.addAll(child.stream().map(ii -> ii.getCode()).collect(Collectors.toList()));

        item.addAll(child);

        return item;
    }
}
