package com.bcxin.tenant.open.dubbo.writer.providers.impls;

import com.bcxin.tenant.open.domains.services.DailyBillService;
import com.bcxin.tenant.open.domains.services.commands.GenerateDailyBillCommand;
import com.bcxin.tenant.open.jdks.DailyBillRpcProvider;
import com.bcxin.tenant.open.jdks.requests.DailyBillWriteRequest;
import org.apache.dubbo.config.annotation.DubboService;

@DubboService
public class DailyBillRpcProviderImpl implements DailyBillRpcProvider {
    private DailyBillService dailyBillService;

    public DailyBillRpcProviderImpl(DailyBillService dailyBillService){
        this.dailyBillService = dailyBillService;
    }
    @Override
    public void billGenerated(DailyBillWriteRequest request) {
        this.dailyBillService.dispatch(GenerateDailyBillCommand.create(request.getDate(),request.getBillTypes()));
    }
}
