package com.bcxin.tenant.open.dubbo.writer.providers.impls;

import com.bcxin.tenant.open.document.domains.documents.RdCommunityUserDocument;
import com.bcxin.tenant.open.document.domains.documents.RdDispatchDataScopeDocument;
import com.bcxin.tenant.open.document.domains.documents.RdDispatchDataScopeDocument$;
import com.bcxin.tenant.open.document.domains.repositories.RdCommunityUserDocumentRepository;
import com.bcxin.tenant.open.domains.entities.RdCommunityUserEntity;
import com.bcxin.tenant.open.domains.repositories.RdCommunityUserRepository;
import com.bcxin.tenant.open.dubbo.writer.providers.translates.DataTranslate;
import com.bcxin.tenant.open.infrastructures.components.JsonProvider;
import com.bcxin.tenant.open.jdks.CommunityUserWriterRpcProvider;
import com.bcxin.tenant.open.jdks.EmployeeWriterRpcProvider;
import com.bcxin.tenant.open.jdks.SecurityStationWriterRpcProvider;
import com.redis.om.spring.search.stream.EntityStream;
import com.redis.om.spring.search.stream.SearchStream;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;

@DubboService
public class CommunityUserWriterRpcProviderImpl implements CommunityUserWriterRpcProvider {
    private static final Logger logger = LoggerFactory.getLogger(CommunityUserWriterRpcProviderImpl.class);

    private final RdCommunityUserDocumentRepository communityUserDocumentRepository;
    private final RdCommunityUserRepository communityUserRepository;
    private final DataTranslate dataTranslate;
    private final EmployeeWriterRpcProvider employeeWriterRpcProvider;
    private final SecurityStationWriterRpcProvider securityStationWriterRpcProvider;
    private final EntityStream entityStream;
    private final JsonProvider jsonProvider;

    public CommunityUserWriterRpcProviderImpl(RdCommunityUserDocumentRepository communityUserDocumentRepository,
                                              RdCommunityUserRepository communityUserRepository, DataTranslate dataTranslate,
                                              EmployeeWriterRpcProvider employeeWriterRpcProvider,
                                              SecurityStationWriterRpcProvider securityStationWriterRpcProvider,
                                              EntityStream entityStream, JsonProvider jsonProvider) {
        this.communityUserDocumentRepository = communityUserDocumentRepository;
        this.communityUserRepository = communityUserRepository;
        this.dataTranslate = dataTranslate;
        this.employeeWriterRpcProvider = employeeWriterRpcProvider;
        this.securityStationWriterRpcProvider = securityStationWriterRpcProvider;
        this.entityStream = entityStream;
        this.jsonProvider = jsonProvider;
    }

    @Override
    public int flush2Redis(Collection<String> ids) {
        int pageIndex = 1;
        int pageSize = 5000;

        int totalCount = 0;
        Collection<RdCommunityUserEntity> communityUsers = this.communityUserRepository.getByPage(ids, pageIndex, pageSize);
        Collection<String> notExistsIds = new ArrayList<>();
        if (!CollectionUtils.isEmpty(ids)) {
            notExistsIds = ids.stream().toList();
        }
        while (!CollectionUtils.isEmpty(communityUsers)) {
            if (!CollectionUtils.isEmpty(notExistsIds)) {
                Collection<String> existsIds = communityUsers.stream().map(ii -> ii.getId()).collect(Collectors.toList());
                /**
                 * 使用Remove会抛null异常
                 */
                notExistsIds = notExistsIds.stream().filter(ii -> !existsIds.contains(ii)).collect(Collectors.toList());
            }

            Collection<RdCommunityUserDocument> documents =
                    this.dataTranslate.translate(communityUsers);
            if (CollectionUtils.isEmpty(documents)) {
                return totalCount;
            }

            Collection<RdCommunityUserEntity> finalCommunityUsers = communityUsers;
            Collection<RdCommunityUserDocument> deletedDocuments
                    = documents.stream().filter(ix -> {
                return finalCommunityUsers.stream()
                        .anyMatch(ii -> ii.isDeleted() && ii.getId().equalsIgnoreCase(ix.getId()));
            }).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(deletedDocuments)) {
                this.communityUserDocumentRepository.deleteAll(deletedDocuments);
            }

            Collection<RdCommunityUserDocument> noDeletedDocuments
                    = documents.stream().filter(ii->
                            !deletedDocuments.stream().anyMatch(ix->ix.getId().equalsIgnoreCase(ii.getId()))
                    ).collect(Collectors.toList());

            if(!CollectionUtils.isEmpty(noDeletedDocuments)) {
                this.communityUserDocumentRepository.saveAll(noDeletedDocuments);
            }

            Collection<String> tenantUserIds = documents.stream()
                    .map(ii->ii.getTenantUserId())
                    .distinct().collect(Collectors.toList());
            this.employeeWriterRpcProvider.flush2RedisByTenantUserIds(tenantUserIds);
            Collection<String> stationIds =
            this.employeeWriterRpcProvider.getStationIdsByEmployeeIds(
                    communityUsers.stream().map(ii->ii.getEmployeeId()).collect(Collectors.toList())
            );
            if(!CollectionUtils.isEmpty(stationIds)) {
                this.securityStationWriterRpcProvider.flush2Redis(stationIds);
            }

            logger.info("完成刷新CommunityUser:pageIndex={}; count={};", pageIndex, documents.size());

            pageIndex++;

            if (communityUsers.size() < pageSize) {
                break;
            }

            communityUsers = this.communityUserRepository.getByPage(ids, pageIndex, pageSize);
            totalCount += documents.size();
        }

        /**
         * 清除不在需要的文档
         */
        if (!CollectionUtils.isEmpty(notExistsIds)) {
            this.communityUserDocumentRepository.deleteAllById(notExistsIds);
        }
        return totalCount;
    }

    @Override
    public Collection<String> getJsonResult(Collection<String> ids) {
        SearchStream<RdCommunityUserDocument> communityUserDocumentSearchStream =
                this.entityStream.of(RdCommunityUserDocument.class);
        if (!CollectionUtils.isEmpty(ids)) {
            String[] selectedIds = ids.toArray(ix -> new String[ix]);

            communityUserDocumentSearchStream =
                    communityUserDocumentSearchStream.filter(RdDispatchDataScopeDocument$.ID.in(selectedIds));
        }

        return communityUserDocumentSearchStream.collect(Collectors.toList())
                .stream().map(ix -> this.jsonProvider.getJson(ix)).collect(Collectors.toList());
    }
}
