package com.bcxin.tenant.open.dubbo.writer.providers.impls;

import com.bcxin.tenant.open.domains.components.CacheProvider;
import com.bcxin.tenant.open.domains.components.HotCacheManager;
import com.bcxin.tenant.open.domains.dtos.SystemSettingDTO;
import com.bcxin.tenant.open.jdks.CacheWriterProvider;
import org.apache.commons.collections.map.HashedMap;
import org.apache.dubbo.config.annotation.DubboService;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

@DubboService
public class CacheWriterProviderImpl implements CacheWriterProvider {
    private final CacheProvider cacheProvider;

    public CacheWriterProviderImpl(CacheProvider cacheProvider) {
        this.cacheProvider = cacheProvider;
    }

    @Override
    public Collection<String> getAllKeys() {
        Collection<String> values = new ArrayList<>();
        values.addAll(HotCacheManager.getKeys());
        values.add(SystemSettingDTO.CACHE_KEY);

        return values;
    }

    @Override
    public Object get(String key) {
        Map<String, Object> value = new HashedMap();
        value.put(String.format("%s_%s", HotCacheManager.CacheDataType.SecurityStation, key), HotCacheManager.get(HotCacheManager.CacheDataType.SecurityStation, key));
        value.put(String.format("%s_%s", HotCacheManager.CacheDataType.EnableFaceValidation, key), HotCacheManager.get(HotCacheManager.CacheDataType.EnableFaceValidation, key));
        value.put(String.format("%s_%s_remote", HotCacheManager.CacheDataType.EnableFaceValidation, key), cacheProvider.get(key, SystemSettingDTO.class));

        return value;
    }

    @Override
    public void delete(String key) {
        if (key.startsWith("EnableFaceValidation")) {
            HotCacheManager.remove(HotCacheManager.CacheDataType.EnableFaceValidation, SystemSettingDTO.CACHE_KEY);
            cacheProvider.delete(SystemSettingDTO.CACHE_KEY);
        }
        HotCacheManager.remove(HotCacheManager.CacheDataType.SecurityStation, key);
    }

    @Override
    public void delete(Collection<String> keys) {
        keys.forEach(ik -> {
            this.delete(ik);
        });
    }

    @Override
    public void put(String key, Object value) {
        String[] splits = key.split("@");
        if (splits.length > 1) {
            if (splits[0].equalsIgnoreCase("EnableFaceValidation")) {
                HotCacheManager.put(HotCacheManager.CacheDataType.EnableFaceValidation, HotCacheManager.KEY_ENABLE_FACE_VALIDATION, value);

                return;
            }
        }

        HotCacheManager.put(HotCacheManager.CacheDataType.SecurityStation, key, value);
    }
}
