package com.bcxin.tenant.open.dubbo.writer.providers.impls;

import com.bcxin.tenant.open.domains.BillPaymentRuleConfig;
import com.bcxin.tenant.open.domains.entities.AnalyticsLogEntity;
import com.bcxin.tenant.open.domains.services.AnalyticsLogService;
import com.bcxin.tenant.open.domains.services.commands.CreateAnalyticsLogCommand;
import com.bcxin.tenant.open.infrastructures.TenantContext;
import com.bcxin.tenant.open.infrastructures.TenantEmployeeContext;
import com.bcxin.tenant.open.infrastructures.components.JsonProvider;
import com.bcxin.tenant.open.infrastructures.enums.AnalyticsLogType;
import com.bcxin.tenant.open.infrastructures.exceptions.BadTenantException;
import com.bcxin.tenant.open.infrastructures.exceptions.UnAuthorizedTenantException;
import com.bcxin.tenant.open.jdks.AnalyticsLogRpcProvider;
import com.bcxin.tenant.open.jdks.requests.AnalyticsLogCreateRequest;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.util.CollectionUtils;

import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;

@DubboService
public class AnalyticsLogRpcProviderImpl implements AnalyticsLogRpcProvider {
    private final AnalyticsLogService analyticsLogService;
    private final JsonProvider jsonProvider;

    private final BillPaymentRuleConfig billPaymentRuleConfig;

    public AnalyticsLogRpcProviderImpl(AnalyticsLogService analyticsLogService, JsonProvider jsonProvider, BillPaymentRuleConfig billPaymentRuleConfig) {
        this.analyticsLogService = analyticsLogService;
        this.jsonProvider = jsonProvider;
        this.billPaymentRuleConfig = billPaymentRuleConfig;
    }

    @Override
    public void create(AnalyticsLogCreateRequest request) {
        TenantEmployeeContext.TenantUserModel userModel = TenantContext.getInstance().getUserContext().get();
        if(userModel == null){
            throw new UnAuthorizedTenantException();
        }
        /**调度者是否是账单支付者*/
        boolean isCurrentUserThePaymentOwner = billPaymentRuleConfig.isPaymentOwner(
                userModel.getOrganizationId(),
                userModel.getOrgInstitutional(),
                userModel.getSuperviseRegionCode()
        );
        Collection<AnalyticsLogCreateRequest.AnalyticsLogParams> analyticsLogs = request.getAnalyticsLogs();
        if(CollectionUtils.isEmpty(analyticsLogs)) {
            throw new BadTenantException("请求无效，参数格式不正确");
        }

        Collection<AnalyticsLogEntity> entities = analyticsLogs.stream().map(ix->{
            String referenceNumber = ix.getReferenceNumber();
            AnalyticsLogType type  = ix.getType();
            Map<String,String> params = ix.getParams();
            if(referenceNumber == null || type == null){
                throw new BadTenantException("参数格式不正确，referenceNumber,type为必须参数");
            }
            AnalyticsLogEntity entity = AnalyticsLogEntity.create(
                    userModel.getEmployeeId(),
                    userModel.getName(),
                    userModel.isSupervise() ? 1 : 0,
                    type,
                    userModel.getOrganizationId(),
                    referenceNumber,
                    ix.getReferenceName(),
                    ix.getOrganizationId(),
                    jsonProvider.getJson(params),
                    isCurrentUserThePaymentOwner ? userModel.getOrganizationId() : ix.getOrganizationId());
            return entity;
        }).collect(Collectors.toList());

        analyticsLogService.dispatch(CreateAnalyticsLogCommand.create(entities));
    }
}
