package com.bcxin.tenant.open.dubbo.writer.providers.eventListeners;

import com.bcxin.tenant.open.document.domains.documents.RdCompanyDocument;
import com.bcxin.tenant.open.document.domains.documents.RdCompanyDocument$;
import com.bcxin.tenant.open.domains.events.EmployeeStatusChangedEvent;
import com.bcxin.tenant.open.infrastructures.enums.DispatchDataType;
import com.bcxin.tenant.open.jdks.RdSyncRpcWriterProvider;
import com.bcxin.tenant.open.jdks.requests.SyncParameterWrapperRequest;
import com.redis.om.spring.search.stream.EntityStream;
import com.redis.om.spring.search.stream.SearchStream;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.Collection;
import java.util.stream.Collectors;

@Component
public class EmployeeStatusChangedEventListener_RdCompanyDocument implements ApplicationListener<EmployeeStatusChangedEvent> {

    private final EntityStream entityStream;
    private final RdSyncRpcWriterProvider syncRpcWriterProvider;

    public EmployeeStatusChangedEventListener_RdCompanyDocument(EntityStream entityStream,
                                                                RdSyncRpcWriterProvider syncRpcWriterProvider) {
        this.entityStream = entityStream;
        this.syncRpcWriterProvider = syncRpcWriterProvider;
    }

    @Override
    public void onApplicationEvent(EmployeeStatusChangedEvent event) {
        /**
         * 无需此操作; 通过KafkaComponent_RefreshRelative实现
         */
        if(false) {
            SearchStream<RdCompanyDocument> searchStream =
                    this.entityStream.of(RdCompanyDocument.class);
            Collection<RdCompanyDocument> documents =
                    searchStream
                            .filter(RdCompanyDocument$.ID.eq(event.getOrganizationId()))
                            .collect(Collectors.toList());

            if (CollectionUtils.isEmpty(documents)) {
                return;
            }

            Collection<String> organizationIds =
                    documents.stream().map(ix -> ix.getId())
                            .collect(Collectors.toList());

            this.syncRpcWriterProvider.sync(SyncParameterWrapperRequest.create(
                    DispatchDataType.Company,organizationIds));
        }
    }
}
