package com.bcxin.tenant.open.dubbo.writer.providers.eventListeners;
import com.bcxin.tenant.open.document.domains.documents.RdSecurityStationDocument;
import com.bcxin.tenant.open.document.domains.documents.RdSecurityStationDocument$;
import com.bcxin.tenant.open.domains.events.CompanyNameChangedEvent;
import com.bcxin.tenant.open.infrastructures.enums.DispatchDataType;
import com.bcxin.tenant.open.jdks.RdSyncRpcWriterProvider;
import com.bcxin.tenant.open.jdks.requests.SyncParameterWrapperRequest;
import com.redis.om.spring.search.stream.EntityStream;
import com.redis.om.spring.search.stream.SearchStream;
import lombok.Getter;
import org.springframework.context.ApplicationListener;
import org.springframework.util.CollectionUtils;

import java.util.Collection;
import java.util.stream.Collectors;

@Getter
public class CompanyNameChangedEventListener_RdStationDocument implements ApplicationListener<CompanyNameChangedEvent> {

    private final EntityStream entityStream;
    private final RdSyncRpcWriterProvider syncRpcWriterProvider;
    public CompanyNameChangedEventListener_RdStationDocument(EntityStream entityStream,
                                                             RdSyncRpcWriterProvider syncRpcWriterProvider) {
        this.entityStream = entityStream;
        this.syncRpcWriterProvider = syncRpcWriterProvider;
    }

    @Override
    public void onApplicationEvent(CompanyNameChangedEvent event) {
        /**
         * 无需此操作; 通过KafkaComponent_RefreshRelative实现
         */
        if(false) {
            SearchStream<RdSecurityStationDocument> searchStream =
                    this.entityStream.of(RdSecurityStationDocument.class);
            Collection<RdSecurityStationDocument> documents =
                    searchStream
                            .filter(RdSecurityStationDocument$.ORGANIZATION_ID.eq(event.getOrganizationId()))
                            .collect(Collectors.toList());

            if (CollectionUtils.isEmpty(documents)) {
                return;
            }

            Collection<String> stationIds =
                    documents.stream().map(ix -> ix.getId())
                            .collect(Collectors.toList());

            this.syncRpcWriterProvider.sync(SyncParameterWrapperRequest.create( DispatchDataType.Station,stationIds));
        }
    }
}
