package com.bcxin.tenant.open.dubbo.writer.providers.eventListeners;

import com.bcxin.tenant.open.document.domains.documents.RdEmployeeDocument;
import com.bcxin.tenant.open.document.domains.documents.RdEmployeeDocument$;
import com.bcxin.tenant.open.domains.events.CompanyNameChangedEvent;
import com.bcxin.tenant.open.infrastructures.enums.DispatchDataType;
import com.bcxin.tenant.open.jdks.RdSyncRpcWriterProvider;
import com.bcxin.tenant.open.jdks.requests.SyncParameterWrapperRequest;
import com.redis.om.spring.search.stream.EntityStream;
import com.redis.om.spring.search.stream.SearchStream;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.Collection;
import java.util.stream.Collectors;

@Component
public class CompanyNameChangedEventListener_RdEmployeeDocument implements ApplicationListener<CompanyNameChangedEvent> {
    private final EntityStream entityStream;
    private final RdSyncRpcWriterProvider syncRpcWriterProvider;
    public CompanyNameChangedEventListener_RdEmployeeDocument(EntityStream entityStream,
                                                             RdSyncRpcWriterProvider syncRpcWriterProvider) {
        this.entityStream = entityStream;
        this.syncRpcWriterProvider = syncRpcWriterProvider;
    }


    @Override
    public void onApplicationEvent(CompanyNameChangedEvent event) {
        /**
         * 无需此操作; 通过KafkaComponent_RefreshRelative实现
         */
        if(false) {
            SearchStream<RdEmployeeDocument> employeeDocumentSearchStream =
                    this.entityStream.of(RdEmployeeDocument.class);
            Collection<RdEmployeeDocument> documents =
                    employeeDocumentSearchStream
                            .filter(RdEmployeeDocument$.ORGANIZATION_ID.eq(event.getOrganizationId()))
                            .collect(Collectors.toList());

            if (CollectionUtils.isEmpty(documents)) {
                return;
            }

            this.syncRpcWriterProvider.sync(
                    SyncParameterWrapperRequest.create(
                            DispatchDataType.Employee,
                            documents.stream().map(ix -> ix.getId())
                                    .collect(Collectors.toList()))
            );
        }
    }
}
