package com.bcxin.tenant.open.dubbo.writer.providers.configs;
import com.bcxin.tenant.open.dubbo.common.configs.DubboConfigProperty;
import com.bcxin.tenant.open.infrastructures.components.DefaultIdWorkerImpl;
import com.bcxin.tenant.open.infrastructures.components.IdWorker;
import com.bcxin.tenant.open.jdks.HotCacheRpcProvider;
import com.bcxin.tenant.open.jdks.SecurityStationReaderRpcProvider;
import org.apache.dubbo.config.ConsumerConfig;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.spring.context.annotation.EnableDubbo;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;

@EnableDubbo(scanBasePackages = "com.bcxin.tenant.open.dubbo.writer.providers.impls")
@ComponentScan(basePackages = "com.bcxin.tenant")
@Configuration
@EnableConfigurationProperties(SharedApiProperties.class)
public class DubboConfig {

    @DubboReference
    private final SecurityStationReaderRpcProvider securityStationReaderRpcProvider;
    @DubboReference
    private final HotCacheRpcProvider hotCacheRpcProvider;

    public DubboConfig(SecurityStationReaderRpcProvider securityStationReaderRpcProvider, HotCacheRpcProvider hotCacheRpcProvider) {
        this.securityStationReaderRpcProvider = securityStationReaderRpcProvider;
        this.hotCacheRpcProvider = hotCacheRpcProvider;
    }

    @Bean
    public ConsumerConfig registryConfig(DubboConfigProperty property) {
        ConsumerConfig config = new ConsumerConfig();
        config.setCheck(false);
        /**
         * 不过期
         */
        config.setTimeout(120 * 1000);
        /**
         * 禁用重试
         */
        config.setRetries(0);
        config.setVersion(property.getVersion());

        return config;
    }

    @Bean
    public IdWorker idWorker() {
        return new DefaultIdWorkerImpl();
    }
}
