package com.bcxin.tenant.open.dubbo.writer.providers.configs;

import com.bcxin.tenant.open.dubbo.writer.providers.components.DocumentIndexNotFoundEvent;
import com.bcxin.tenant.open.dubbo.writer.providers.components.RefreshIndexComponent;
import com.bcxin.tenant.open.infrastructures.enums.DispatchDataType;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

@Component
public class DocumentIndexNotFoundEventListener implements ApplicationListener<DocumentIndexNotFoundEvent> {
    private final RefreshIndexComponent refreshIndexComponent;

    public DocumentIndexNotFoundEventListener(RefreshIndexComponent refreshIndexComponent) {
        this.refreshIndexComponent = refreshIndexComponent;
    }

    @Override
    public void onApplicationEvent(DocumentIndexNotFoundEvent event) {
        this.refreshIndexComponent.execute(DispatchDataType.Company);
    }
}
