package com.bcxin.tenant.open.dubbo.writer.providers.components.dtos;

import lombok.Getter;

import java.io.Serializable;
import java.util.Collection;

@Getter
public class GeTuiSharedContentDTO<T> implements Serializable {
    private final String title;
    private final String content;
    private final Collection<String> cids;
    private final T data;

    public GeTuiSharedContentDTO(String title, String content, Collection<String> cids, T data) {
        this.title = title;
        this.content = content;
        this.cids = cids;
        this.data = data;
    }

    public static <T> GeTuiSharedContentDTO create(String title, String content, Collection<String> cids, T data) {
        return new GeTuiSharedContentDTO(title, content, cids, data);
    }
}
