package com.bcxin.tenant.open.dubbo.writer.providers.components;

import com.bcxin.tenant.open.infrastructures.enums.DispatchDataType;
import com.redis.om.spring.RediSearchIndexer;
import com.redis.om.spring.annotations.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.data.redis.core.RedisHash;
import org.springframework.stereotype.Component;

@Component
public class RefreshIndexComponentImpl implements RefreshIndexComponent, BeanFactoryAware {
    private static final Logger logger = LoggerFactory.getLogger(RefreshIndexComponentImpl.class);

    @Override
    public void execute(DispatchDataType dataType) {
        try {
            RediSearchIndexer indexer = (RediSearchIndexer) this.beanFactory.getBean("rediSearchIndexer");
            indexer.createIndicesFor(Document.class);
            indexer.createIndicesFor(RedisHash.class);
        } finally {

        }
    }

    private BeanFactory beanFactory;

    @Override
    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }
}
