package com.bcxin.tenant.open.dubbo.writer.providers.components;

import com.bcxin.tenant.open.dubbo.writer.providers.components.dtos.GeTuiSharedContentDTO;
import com.bcxin.tenant.open.dubbo.writer.providers.components.dtos.GeTuiSharedContentResponse;
import com.bcxin.tenant.open.dubbo.writer.providers.components.dtos.RollCallRequestDTO;
import com.bcxin.tenant.open.dubbo.writer.providers.configs.SharedApiProperties;
import com.bcxin.tenant.open.infrastructures.components.JsonProvider;
import com.bcxin.tenant.open.infrastructures.constants.KafkaConstants;
import com.bcxin.tenant.open.infrastructures.exceptions.BadTenantException;
import com.bcxin.tenant.open.infrastructures.utils.ExceptionUtil;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;

@Component
public class GeTuiHttpClientImpl implements GeTuiHttpClient{
    private static final Logger logger = LoggerFactory.getLogger(GeTuiHttpClientImpl.class);

    private final SharedApiProperties sharedApiProperties;
    private final JsonProvider jsonProvider;
    private final CloseableHttpClient httpClient;
    private final KafkaTemplate kafkaTemplate;

    public GeTuiHttpClientImpl(SharedApiProperties sharedApiProperties, JsonProvider jsonProvider,
                               KafkaTemplate kafkaTemplate) {
        this.sharedApiProperties = sharedApiProperties;
        this.jsonProvider = jsonProvider;
        this.kafkaTemplate = kafkaTemplate;
        this.httpClient = HttpClientBuilder.create().build();
    }


    @Override
    public GeTuiSharedContentResponse doPost(GeTuiSharedContentDTO content) {
        String bodyJson = null;
        String responseBody = null;
        String exception = null;
        try {
            HttpPost doPost = new HttpPost(sharedApiProperties.getAppDispatchPath());
            bodyJson = this.jsonProvider.getJson(content);
            StringEntity bodyEntity = new StringEntity(bodyJson, StandardCharsets.UTF_8);
            bodyEntity.setContentType("application/json");
            doPost.setEntity(bodyEntity);

            try (CloseableHttpResponse closeableHttpResponse = this.httpClient.execute(doPost)) {
                responseBody = EntityUtils.toString(closeableHttpResponse.getEntity());
                if (closeableHttpResponse.getStatusLine() != null && closeableHttpResponse.getStatusLine().getStatusCode() < 300) {
                    GeTuiSharedContentResponse  response = this.jsonProvider.toObject(GeTuiSharedContentResponse.class, responseBody);
                    response.setPostAPi(sharedApiProperties.getAppDispatchPath());

                    return response;
                } else {
                    throw new BadTenantException(responseBody);
                }
            }
        } catch (Exception ex) {
            exception = ExceptionUtil.getStackMessage(ex);
            throw new BadTenantException(String.format("执行个推请求发生异常:%s",sharedApiProperties.getAppDispatchPath()), ex);
        } finally {
            logger.error("个推请求日志:api={}; body={}; response={}",
                    sharedApiProperties.getAppDispatchPath(),
                    bodyJson, responseBody, exception);
        }
    }
}
