/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.open.domains.entities;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.bcxin.tenant.open.domains.entities.RollCallEmployeeEntity;
import com.bcxin.tenant.open.infrastructures.entities.Aggregate;
import com.bcxin.tenant.open.infrastructures.entities.EntityAbstract;
import com.bcxin.tenant.open.infrastructures.enums.RollCallStatus;
import com.bcxin.tenant.open.infrastructures.enums.RollCallType;
import java.sql.Timestamp;
import java.time.Instant;
import org.apache.ibatis.type.EnumOrdinalTypeHandler;
import org.apache.ibatis.type.JdbcType;

@TableName(value="vga_roll_call_employee_histories", autoResultMap=true)
public class RollCallEmployeeHistoryEntity
extends EntityAbstract
implements Aggregate {
    @TableId(value="id")
    private Long id;
    @TableField(value="roll_call_id")
    private Long rollCallId;
    @TableField(value="roll_call_employee_id")
    private String rollCallEmployeeId;
    @TableField(value="called_employee_id")
    private String calledEmployeeId;
    @TableField(value="room_id")
    private String roomId;
    @TableField(value="status", jdbcType=JdbcType.TINYINT, javaType=true, typeHandler=EnumOrdinalTypeHandler.class)
    private RollCallStatus status;
    @TableField(value="call_type", jdbcType=JdbcType.TINYINT, javaType=true, typeHandler=EnumOrdinalTypeHandler.class)
    private RollCallType callType;
    @TableField(value="created_time")
    private Timestamp createdTime;
    @TableField(value="action_employee_id")
    private String actionEmployeeId;
    @TableField(value="action_employee_name")
    private String actionEmployeeName;
    @TableField(value="note")
    private String note;

    public RollCallEmployeeHistoryEntity() {
        this.setCreatedTime(Timestamp.from(Instant.now()));
    }

    public static RollCallEmployeeHistoryEntity create(RollCallType callType, String roomId, RollCallEmployeeEntity employee, RollCallStatus status, String note) {
        RollCallEmployeeHistoryEntity history = new RollCallEmployeeHistoryEntity();
        history.setActionEmployeeId(employee.getCalledEmployeeId());
        history.setRollCallId(employee.getRollCallId());
        history.setActionEmployeeName(employee.getCalledEmployeeName());
        history.setRollCallEmployeeId(employee.getId());
        history.setCalledEmployeeId(employee.getCalledEmployeeId());
        history.setCallType(callType);
        history.setStatus(status);
        history.setRoomId(roomId);
        history.setNote(note);
        return history;
    }

    public static RollCallEmployeeHistoryEntity create(RollCallType callType, RollCallEmployeeEntity employee, RollCallStatus status, String note) {
        RollCallEmployeeHistoryEntity history = new RollCallEmployeeHistoryEntity();
        history.setActionEmployeeId("#1");
        history.setActionEmployeeName("#1");
        history.setRollCallEmployeeId(employee.getId());
        history.setRollCallId(employee.getRollCallId());
        history.setCallType(callType);
        history.setCalledEmployeeId(employee.getCalledEmployeeId());
        history.setStatus(status);
        history.setNote(note);
        return history;
    }

    public Long getId() {
        return this.id;
    }

    public Long getRollCallId() {
        return this.rollCallId;
    }

    public String getRollCallEmployeeId() {
        return this.rollCallEmployeeId;
    }

    public String getCalledEmployeeId() {
        return this.calledEmployeeId;
    }

    public String getRoomId() {
        return this.roomId;
    }

    public RollCallStatus getStatus() {
        return this.status;
    }

    public RollCallType getCallType() {
        return this.callType;
    }

    public Timestamp getCreatedTime() {
        return this.createdTime;
    }

    public String getActionEmployeeId() {
        return this.actionEmployeeId;
    }

    public String getActionEmployeeName() {
        return this.actionEmployeeName;
    }

    public String getNote() {
        return this.note;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setRollCallId(Long rollCallId) {
        this.rollCallId = rollCallId;
    }

    public void setRollCallEmployeeId(String rollCallEmployeeId) {
        this.rollCallEmployeeId = rollCallEmployeeId;
    }

    public void setCalledEmployeeId(String calledEmployeeId) {
        this.calledEmployeeId = calledEmployeeId;
    }

    public void setRoomId(String roomId) {
        this.roomId = roomId;
    }

    public void setStatus(RollCallStatus status) {
        this.status = status;
    }

    public void setCallType(RollCallType callType) {
        this.callType = callType;
    }

    public void setCreatedTime(Timestamp createdTime) {
        this.createdTime = createdTime;
    }

    public void setActionEmployeeId(String actionEmployeeId) {
        this.actionEmployeeId = actionEmployeeId;
    }

    public void setActionEmployeeName(String actionEmployeeName) {
        this.actionEmployeeName = actionEmployeeName;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RollCallEmployeeHistoryEntity)) {
            return false;
        }
        RollCallEmployeeHistoryEntity other = (RollCallEmployeeHistoryEntity)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$rollCallId = this.getRollCallId();
        Long other$rollCallId = other.getRollCallId();
        if (this$rollCallId == null ? other$rollCallId != null : !((Object)this$rollCallId).equals(other$rollCallId)) {
            return false;
        }
        String this$rollCallEmployeeId = this.getRollCallEmployeeId();
        String other$rollCallEmployeeId = other.getRollCallEmployeeId();
        if (this$rollCallEmployeeId == null ? other$rollCallEmployeeId != null : !this$rollCallEmployeeId.equals(other$rollCallEmployeeId)) {
            return false;
        }
        String this$calledEmployeeId = this.getCalledEmployeeId();
        String other$calledEmployeeId = other.getCalledEmployeeId();
        if (this$calledEmployeeId == null ? other$calledEmployeeId != null : !this$calledEmployeeId.equals(other$calledEmployeeId)) {
            return false;
        }
        String this$roomId = this.getRoomId();
        String other$roomId = other.getRoomId();
        if (this$roomId == null ? other$roomId != null : !this$roomId.equals(other$roomId)) {
            return false;
        }
        RollCallStatus this$status = this.getStatus();
        RollCallStatus other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        RollCallType this$callType = this.getCallType();
        RollCallType other$callType = other.getCallType();
        if (this$callType == null ? other$callType != null : !this$callType.equals(other$callType)) {
            return false;
        }
        Timestamp this$createdTime = this.getCreatedTime();
        Timestamp other$createdTime = other.getCreatedTime();
        if (this$createdTime == null ? other$createdTime != null : !((Object)this$createdTime).equals(other$createdTime)) {
            return false;
        }
        String this$actionEmployeeId = this.getActionEmployeeId();
        String other$actionEmployeeId = other.getActionEmployeeId();
        if (this$actionEmployeeId == null ? other$actionEmployeeId != null : !this$actionEmployeeId.equals(other$actionEmployeeId)) {
            return false;
        }
        String this$actionEmployeeName = this.getActionEmployeeName();
        String other$actionEmployeeName = other.getActionEmployeeName();
        if (this$actionEmployeeName == null ? other$actionEmployeeName != null : !this$actionEmployeeName.equals(other$actionEmployeeName)) {
            return false;
        }
        String this$note = this.getNote();
        String other$note = other.getNote();
        return !(this$note == null ? other$note != null : !this$note.equals(other$note));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RollCallEmployeeHistoryEntity;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $rollCallId = this.getRollCallId();
        result = result * 59 + ($rollCallId == null ? 43 : ((Object)$rollCallId).hashCode());
        String $rollCallEmployeeId = this.getRollCallEmployeeId();
        result = result * 59 + ($rollCallEmployeeId == null ? 43 : $rollCallEmployeeId.hashCode());
        String $calledEmployeeId = this.getCalledEmployeeId();
        result = result * 59 + ($calledEmployeeId == null ? 43 : $calledEmployeeId.hashCode());
        String $roomId = this.getRoomId();
        result = result * 59 + ($roomId == null ? 43 : $roomId.hashCode());
        RollCallStatus $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        RollCallType $callType = this.getCallType();
        result = result * 59 + ($callType == null ? 43 : $callType.hashCode());
        Timestamp $createdTime = this.getCreatedTime();
        result = result * 59 + ($createdTime == null ? 43 : ((Object)$createdTime).hashCode());
        String $actionEmployeeId = this.getActionEmployeeId();
        result = result * 59 + ($actionEmployeeId == null ? 43 : $actionEmployeeId.hashCode());
        String $actionEmployeeName = this.getActionEmployeeName();
        result = result * 59 + ($actionEmployeeName == null ? 43 : $actionEmployeeName.hashCode());
        String $note = this.getNote();
        result = result * 59 + ($note == null ? 43 : $note.hashCode());
        return result;
    }

    public String toString() {
        return "RollCallEmployeeHistoryEntity(id=" + this.getId() + ", rollCallId=" + this.getRollCallId() + ", rollCallEmployeeId=" + this.getRollCallEmployeeId() + ", calledEmployeeId=" + this.getCalledEmployeeId() + ", roomId=" + this.getRoomId() + ", status=" + this.getStatus() + ", callType=" + this.getCallType() + ", createdTime=" + this.getCreatedTime() + ", actionEmployeeId=" + this.getActionEmployeeId() + ", actionEmployeeName=" + this.getActionEmployeeName() + ", note=" + this.getNote() + ")";
    }
}

