/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.open.domains.components;

import com.bcxin.tenant.open.domains.components.CacheProvider;
import com.bcxin.tenant.open.infrastructures.components.JsonProvider;
import java.util.function.Supplier;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class CacheProviderImpl
implements CacheProvider {
    private final RedisTemplate redisTemplate;
    private final JsonProvider jsonProvider;

    public CacheProviderImpl(RedisTemplate redisTemplate, JsonProvider jsonProvider) {
        this.redisTemplate = redisTemplate;
        this.jsonProvider = jsonProvider;
    }

    @Override
    public <T> T get(String key, Supplier<T> supplier, Class<T> tClass) {
        try {
            T data = this.get(key, tClass);
            if (data == null && (data = supplier.get()) != null) {
                this.redisTemplate.opsForValue().set((Object)key, (Object)this.jsonProvider.getJson(data));
            }
            return data;
        }
        catch (Exception ex) {
            return supplier.get();
        }
    }

    @Override
    public void delete(String key) {
        this.redisTemplate.delete((Object)key);
    }

    @Override
    public <T> T get(String key, Class<T> tClass) {
        String content = (String)this.redisTemplate.opsForValue().get((Object)key);
        Object data = null;
        if (StringUtils.hasLength((String)content)) {
            data = this.jsonProvider.toObject(tClass, content);
        }
        return (T)data;
    }
}

