/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.open.domains.dtos;

import com.bcxin.tenant.open.infrastructures.enums.ProcessedStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;
import org.springframework.util.CollectionUtils;

public class RdSyncEventWrapperDTO {
    private final Collection<RdSyncEventItemDTO> doneEventItems;
    private final Collection<RdSyncEventItemDTO> errorEventItems;

    public RdSyncEventWrapperDTO(Collection<RdSyncEventItemDTO> syncEventItems) {
        if (CollectionUtils.isEmpty(syncEventItems)) {
            syncEventItems = new ArrayList<RdSyncEventItemDTO>();
        }
        this.doneEventItems = syncEventItems.stream().filter(ii -> ii.getStatus() == ProcessedStatus.Done).collect(Collectors.toList());
        this.errorEventItems = syncEventItems.stream().filter(ii -> ii.getStatus() == ProcessedStatus.Error).collect(Collectors.toList());
    }

    public static RdSyncEventWrapperDTO create(Collection<RdSyncEventItemDTO> syncEventItems) {
        return new RdSyncEventWrapperDTO(syncEventItems);
    }

    public Collection<RdSyncEventItemDTO> getDoneEventItems() {
        return this.doneEventItems;
    }

    public Collection<RdSyncEventItemDTO> getErrorEventItems() {
        return this.errorEventItems;
    }

    public static class RdSyncEventItemDTO {
        private final Long pkId;
        private final ProcessedStatus status;
        private final String result;

        public RdSyncEventItemDTO(Long pkId, ProcessedStatus status, String result) {
            this.pkId = pkId;
            this.status = status;
            this.result = result;
        }

        public static RdSyncEventItemDTO create(Long pkId, ProcessedStatus status, String result) {
            return new RdSyncEventItemDTO(pkId, status, result);
        }

        public Long getPkId() {
            return this.pkId;
        }

        public ProcessedStatus getStatus() {
            return this.status;
        }

        public String getResult() {
            return this.result;
        }
    }
}

