/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.open.domains.criterias;

import com.bcxin.tenant.open.infrastructures.criterias.CriteriaAbstract;
import com.bcxin.tenant.open.infrastructures.enums.ResourceType;
import java.util.Collection;
import java.util.stream.Collectors;

public class CompanyAdvanceCriteria
extends CriteriaAbstract {
    private final String name;
    private final Boolean hasPoints;
    private final Boolean hasDesk;
    private final Boolean hasLocation;
    private final Collection<String> organizationIds;
    private final Collection<String> superviseDepartIds;
    private final Collection<Integer> resourceTypes;

    public CompanyAdvanceCriteria(int pageIndex, int pageSize, String name, Boolean hasPoints, Boolean hasDesk, Boolean hasLocation, Collection<String> organizationIds, Collection<String> superviseDepartIds, Collection<ResourceType> resourceTypes) {
        super(pageIndex, pageSize);
        this.name = name;
        this.hasPoints = hasPoints;
        this.hasDesk = hasDesk;
        this.hasLocation = hasLocation;
        this.organizationIds = organizationIds;
        this.superviseDepartIds = superviseDepartIds;
        this.resourceTypes = resourceTypes.stream().map(ii -> ii.ordinal()).collect(Collectors.toList());
    }

    public static CompanyAdvanceCriteria create(int pageIndex, int pageSize, String name, Boolean hasPoints, Boolean hasDesk, Boolean hasLocation, Collection<String> organizationIds, Collection<String> superviseDepartIds, Collection<ResourceType> resourceTypes) {
        return new CompanyAdvanceCriteria(pageIndex, pageSize, name, hasPoints, hasDesk, hasLocation, organizationIds, superviseDepartIds, resourceTypes);
    }

    public String getName() {
        return this.name;
    }

    public Boolean getHasPoints() {
        return this.hasPoints;
    }

    public Boolean getHasDesk() {
        return this.hasDesk;
    }

    public Boolean getHasLocation() {
        return this.hasLocation;
    }

    public Collection<String> getOrganizationIds() {
        return this.organizationIds;
    }

    public Collection<String> getSuperviseDepartIds() {
        return this.superviseDepartIds;
    }

    public Collection<Integer> getResourceTypes() {
        return this.resourceTypes;
    }
}

