/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.flink.job;

import com.bcxin.flink.core.AppAbstract;
import com.bcxin.flink.core.properties.CheckpointConfigProperty;
import com.bcxin.tenant.flink.job.StreamingJobContext;
import com.bcxin.tenant.flink.job.definitions.JobDataDefinition;
import com.bcxin.tenant.flink.job.jobs.ScriptDispatchJob;
import com.bcxin.tenant.open.infrastructures.components.JsonProvider;
import java.io.IOException;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamingJobApp
extends AppAbstract {
    private static Logger logger = LoggerFactory.getLogger(StreamingJobApp.class);

    public static void main(String[] args) throws Exception {
        System.setProperty("org.slf4j.simpleLogger.defaultLogLevel", "info");
        if (args.length < 1) {
            throw new IllegalArgumentException("\u914d\u7f6e\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        StreamingJobApp.initEnv((String[])args);
        JobDataDefinition definition = StreamingJobApp.initJobDataDefinition(args[1]);
        ScriptDispatchJob job = new ScriptDispatchJob(definition);
        job.execute();
    }

    private static JobDataDefinition initJobDataDefinition(String jobId) throws IOException {
        JsonProvider.DefaultJsonProvider jsonProvider = new JsonProvider.DefaultJsonProvider();
        CheckpointConfigProperty configProperty = StreamingJobApp.initCheckPointAndEnv((JsonProvider)jsonProvider, (String)jobId);
        Properties properties = System.getProperties();
        StreamingJobContext.init(properties.getProperty("job.name"), configProperty);
        String databasePropertyConf = StreamingJobApp.getDatabasePropertyConfAfterInitEnv();
        JobDataDefinition definition = (JobDataDefinition)((Object)jsonProvider.toObject(JobDataDefinition.class, databasePropertyConf));
        return definition;
    }
}

