import React, { Component } from 'react';
import st from 'styled-components';
import { connect } from 'dva';
import moment from 'moment';
import {
  Alert,
  Modal,
  DatePicker,
  Table,
  Form
} from 'antd';
import { withRouter } from 'dva/router';
import { } from '../../../../../../services/api';
import $modal from '../../../../../../utils/modal';
import columnFun from './delCol';

const dateFormat = 'YYYY-MM-DD';
@connect(state => ({
  global: state.global
}))
@Form.create()
@withRouter
export default class DelModal extends Component {
  constructor(props, context) {
    super(props, context);
    this.state = {

    };
  }


  componentWillMount() {

  }


  // 表格渲染
  __renderTable = () => {
    const columns = columnFun.call(this);
    const { importInfo } = this.props;
    const minusInsList = importInfo.minusInsList || [];
    minusInsList.map((item, index) => {
      item.number = index + 1;
      return item;
    })
    return (
      <TabContainer>
        <Table
          columns={columns}
          dataSource={minusInsList}
          // rowClassName={record => {
          //   // log(record, 'record')
          //   if(record.removed) {
          //     return 'deleted_row';
          //   }else {
          //     return '';
          //   }
          // }}
          onRow={record => {
            return {
              onMouseEnter() { return; }
            }
          }}
        />
      </TabContainer>
    );
  };

  render() {
    const { visible, importInfo } = this.props;
    const { getFieldDecorator } = this.props.form;
    return (
      <Modal
        visible={visible}
        width={900}
        okText="确定"
        cancelText="上一步"
        onOk={() => {
          this.props.setState({
            delModal: false
          });
          $modal(
            '导入减员成功！',
            <span style={{ color: '#F59A23' }}>
            本次共减员
            <em style={{ color: '#108EE9' }}>{importInfo.delCount || 0}</em>
            人
          </span>,
            [
              {
                text: '确定',
                type: 'primary'
              }
            ],
            'success'
          );
          
        }}
        onCancel={() => {
          // 关闭当前弹窗打开上一个弹窗
          this.props.setState({
            delModal: false,
            importModal: true
          });
        }}
      >
        <div style={{ padding: '0 24px' }}>
          <Alert
            message={<div>
              本次导入减员人数共 
            <span style={{color: '#F59A23'}}>{importInfo.successCount}</span>
               人，分别属于以下
            <span style={{color: '#F59A23'}}>{importInfo.minusInsList?importInfo.minusInsList.length: '0'}</span>
                张保单，请
                <span style={{color: '#F59A23'}}>逐一确认</span>
                操作提交减员。
            </div>}
            type="warning"
            showIcon
            style={{ marginBottom: '15px' }}
          />
          <Form layout="inline">
            <Form.Item label="生效时间" >
              {getFieldDecorator('practiceDate', {
                initialValue: moment().add(1, 'days')
              })(
                <DatePicker
                  disabled
                  format={dateFormat}
                />
              )}
            </Form.Item>
          </Form>

          {/* 表格 */}
          {this.__renderTable()}

        </div >
      </Modal>
    );
  }
}

const TabContainer = st.div`
  margin-top: 15px;
  .deleted_row{
    position: relative;
    &::after{
      content: '';
      display: block;
      width: 100%;
      height: 1px;
      position: absolute;
      bottom: 27px;
      left: 0;
      background: #999;
    }
  }
`;