"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _react = require("react");

var _react2 = _interopRequireDefault(_react);

var _propTypes = require("prop-types");

var _propTypes2 = _interopRequireDefault(_propTypes);

var _reactMotion = require("react-motion");

var _reactHammerjs = require("react-hammerjs");

var _reactHammerjs2 = _interopRequireDefault(_reactHammerjs);

var _assign = require("1-liners/assign");

var _assign2 = _interopRequireDefault(_assign);

var _isFunction = require("1-liners/isFunction");

var _isFunction2 = _interopRequireDefault(_isFunction);

var _styles2 = require("./styles");

var _styles3 = _interopRequireDefault(_styles2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var bool = _propTypes2.default.bool,
    number = _propTypes2.default.number,
    array = _propTypes2.default.array,
    object = _propTypes2.default.object,
    string = _propTypes2.default.string,
    func = _propTypes2.default.func,
    oneOfType = _propTypes2.default.oneOfType;

var Drawer = function (_React$Component) {
  _inherits(Drawer, _React$Component);

  function Drawer() {
    var _ref;

    var _temp, _this, _ret;

    _classCallCheck(this, Drawer);

    for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    return _ret = (_temp = (_this = _possibleConstructorReturn(this, (_ref = Drawer.__proto__ || Object.getPrototypeOf(Drawer)).call.apply(_ref, [this].concat(args))), _this), _this.state = {
      currentState: "CLOSED"
    }, _this.isState = function () {
      var _this2;

      return (_this2 = _this).__isState__REACT_HOT_LOADER__.apply(_this2, arguments);
    }, _this.isClosed = function () {
      var _this3;

      return (_this3 = _this).__isClosed__REACT_HOT_LOADER__.apply(_this3, arguments);
    }, _this.isOpen = function () {
      var _this4;

      return (_this4 = _this).__isOpen__REACT_HOT_LOADER__.apply(_this4, arguments);
    }, _this.isOpening = function () {
      var _this5;

      return (_this5 = _this).__isOpening__REACT_HOT_LOADER__.apply(_this5, arguments);
    }, _this.isClosing = function () {
      var _this6;

      return (_this6 = _this).__isClosing__REACT_HOT_LOADER__.apply(_this6, arguments);
    }, _this.onPress = function () {
      var _this7;

      return (_this7 = _this).__onPress__REACT_HOT_LOADER__.apply(_this7, arguments);
    }, _this.onPressUp = function () {
      var _this8;

      return (_this8 = _this).__onPressUp__REACT_HOT_LOADER__.apply(_this8, arguments);
    }, _this.onPan = function () {
      var _this9;

      return (_this9 = _this).__onPan__REACT_HOT_LOADER__.apply(_this9, arguments);
    }, _this.onOverlayTap = function () {
      var _this10;

      return (_this10 = _this).__onOverlayTap__REACT_HOT_LOADER__.apply(_this10, arguments);
    }, _this.calculateWidth = function () {
      var _this11;

      return (_this11 = _this).__calculateWidth__REACT_HOT_LOADER__.apply(_this11, arguments);
    }, _temp), _possibleConstructorReturn(_this, _ret);
  }

  _createClass(Drawer, [{
    key: "__calculateWidth__REACT_HOT_LOADER__",
    value: function __calculateWidth__REACT_HOT_LOADER__() {
      return this.__calculateWidth__REACT_HOT_LOADER__.apply(this, arguments);
    }
  }, {
    key: "__onOverlayTap__REACT_HOT_LOADER__",
    value: function __onOverlayTap__REACT_HOT_LOADER__() {
      return this.__onOverlayTap__REACT_HOT_LOADER__.apply(this, arguments);
    }
  }, {
    key: "__onPan__REACT_HOT_LOADER__",
    value: function __onPan__REACT_HOT_LOADER__() {
      return this.__onPan__REACT_HOT_LOADER__.apply(this, arguments);
    }
  }, {
    key: "__onPressUp__REACT_HOT_LOADER__",
    value: function __onPressUp__REACT_HOT_LOADER__() {
      return this.__onPressUp__REACT_HOT_LOADER__.apply(this, arguments);
    }
  }, {
    key: "__onPress__REACT_HOT_LOADER__",
    value: function __onPress__REACT_HOT_LOADER__() {
      return this.__onPress__REACT_HOT_LOADER__.apply(this, arguments);
    }
  }, {
    key: "__isClosing__REACT_HOT_LOADER__",
    value: function __isClosing__REACT_HOT_LOADER__() {
      return this.__isClosing__REACT_HOT_LOADER__.apply(this, arguments);
    }
  }, {
    key: "__isOpening__REACT_HOT_LOADER__",
    value: function __isOpening__REACT_HOT_LOADER__() {
      return this.__isOpening__REACT_HOT_LOADER__.apply(this, arguments);
    }
  }, {
    key: "__isOpen__REACT_HOT_LOADER__",
    value: function __isOpen__REACT_HOT_LOADER__() {
      return this.__isOpen__REACT_HOT_LOADER__.apply(this, arguments);
    }
  }, {
    key: "__isClosed__REACT_HOT_LOADER__",
    value: function __isClosed__REACT_HOT_LOADER__() {
      return this.__isClosed__REACT_HOT_LOADER__.apply(this, arguments);
    }
  }, {
    key: "__isState__REACT_HOT_LOADER__",
    value: function __isState__REACT_HOT_LOADER__() {
      return this.__isState__REACT_HOT_LOADER__.apply(this, arguments);
    }
  }, {
    key: "componentWillReceiveProps",
    value: function componentWillReceiveProps(nextProps) {
      var open = this.props.open;
      var nextOpen = nextProps.open;


      if (nextOpen !== open) {
        if (nextOpen) this.open();else this.close();
      }
    }
  }, {
    key: "__isState__REACT_HOT_LOADER__",
    value: function __isState__REACT_HOT_LOADER__(s) {
      return s === this.state.currentState;
    }
  }, {
    key: "__isClosed__REACT_HOT_LOADER__",
    value: function __isClosed__REACT_HOT_LOADER__() {
      return this.isState("CLOSED");
    }
  }, {
    key: "__isOpen__REACT_HOT_LOADER__",
    value: function __isOpen__REACT_HOT_LOADER__() {
      return this.isState("OPEN");
    }
  }, {
    key: "__isOpening__REACT_HOT_LOADER__",
    value: function __isOpening__REACT_HOT_LOADER__() {
      return this.isState("IS_OPENING");
    }
  }, {
    key: "__isClosing__REACT_HOT_LOADER__",
    value: function __isClosing__REACT_HOT_LOADER__() {
      return this.isState("IS_CLOSING");
    }
  }, {
    key: "peak",
    value: function peak() {
      var _props = this.props,
          onChange = _props.onChange,
          handleWidth = _props.handleWidth;

      onChange(false);
      return this.setState({ currentState: "PEAK", x: handleWidth });
    }
  }, {
    key: "close",
    value: function close() {
      this.props.onChange(false);
      return this.setState({ currentState: "CLOSED", x: 0 });
    }
  }, {
    key: "open",
    value: function open() {
      var _props2 = this.props,
          onChange = _props2.onChange,
          width = _props2.width;

      onChange(true);

      return this.setState({ currentState: "OPEN", x: this.calculateWidth() });
    }
  }, {
    key: "isClosingDirection",
    value: function isClosingDirection(direction) {
      var right = this.props.right;

      var isClosing = direction === 2;

      if (right) return !isClosing;else return isClosing;
    }
  }, {
    key: "closingOrOpening",
    value: function closingOrOpening(direction) {
      return this.isClosingDirection(direction) ? "IS_CLOSING" : "IS_OPENING";
    }
  }, {
    key: "inPanTolerance",
    value: function inPanTolerance(deltaX) {
      var currentState = this.state.currentState;
      var panTolerance = this.props.panTolerance;


      return Math.abs(deltaX) <= panTolerance && currentState === "OPEN";
    }
  }, {
    key: "__onPress__REACT_HOT_LOADER__",
    value: function __onPress__REACT_HOT_LOADER__(e) {
      if (this.props.noTouchOpen) return;
      e.preventDefault();
      this.peak();
    }
  }, {
    key: "__onPressUp__REACT_HOT_LOADER__",
    value: function __onPressUp__REACT_HOT_LOADER__(e) {
      e.preventDefault();
      this.close();
    }
  }, {
    key: "__onPan__REACT_HOT_LOADER__",
    value: function __onPan__REACT_HOT_LOADER__(e) {
      if (this.isClosed() && this.props.noTouchOpen) return;
      if (this.isOpen() && this.props.noTouchClose) return;
      e.preventDefault();

      var isFinal = e.isFinal,
          pointers = e.pointers,
          direction = e.direction,
          deltaX = e.deltaX;

      if (this.inPanTolerance(deltaX)) return;

      if (isFinal) {
        if (this.isOpening()) this.open();else if (this.isClosing()) this.close();
        return;
      }

      var currentState = this.state.currentState;
      var _props3 = this.props,
          right = _props3.right,
          peakingWidth = _props3.peakingWidth,
          handleWidth = _props3.handleWidth;

      var _calculateWidth = this.calculateWidth(),
          width = _calculateWidth.width;

      var clientX = pointers[0].clientX;


      var x = right ? document.body.clientWidth - clientX : clientX;

      if (x + peakingWidth >= width) x = width - peakingWidth;

      var closingOrOpening = this.closingOrOpening(direction);
      var nextState = {
        PEAK: closingOrOpening,
        IS_OPENING: closingOrOpening,
        IS_CLOSING: closingOrOpening,
        OPEN: "IS_CLOSING",
        CLOSED: "PEAK"
      };

      this.setState({
        currentState: nextState[currentState],
        x: this.isClosed() ? peakingWidth : peakingWidth / 2 + x
      });
    }
  }, {
    key: "__onOverlayTap__REACT_HOT_LOADER__",
    value: function __onOverlayTap__REACT_HOT_LOADER__(e) {
      e.preventDefault();
      if (this.isOpen()) this.close();
    }
  }, {
    key: "__calculateWidth__REACT_HOT_LOADER__",
    value: function __calculateWidth__REACT_HOT_LOADER__() {
      var width = this.props.width;
      return (/\D/.test(width) ? document.body.clientWidth * (width.match(/\d*/) / 100) : width
      );
    }
  }, {
    key: "render",
    value: function render() {
      var _this12 = this;

      var _props4 = this.props,
          config = _props4.config,
          drawerStyle = _props4.drawerStyle,
          className = _props4.className,
          overlayClassName = _props4.overlayClassName,
          width = _props4.width,
          children = _props4.children,
          offset = _props4.offset;
      var _state = this.state,
          currentState = _state.currentState,
          x = _state.x;


      return _react2.default.createElement(
        _reactMotion.Motion,
        { style: { myProp: (0, _reactMotion.spring)(Math.min(x + offset || 0, this.calculateWidth()), config) } },
        function (interpolated) {
          var _styles = (0, _styles3.default)(interpolated.myProp, _this12.props),
              drawer = _styles.drawer,
              transform = _styles.transform,
              overlay = _styles.overlay;

          var computedStyle = (0, _assign2.default)(drawer, drawerStyle);
          if (interpolated.myProp > 0) computedStyle.display = "block";else computedStyle.display = "none";

          return _react2.default.createElement(
            "div",
            { style: transform },
            _react2.default.createElement(
              _reactHammerjs2.default,
              {
                onPress: _this12.onPress,
                onPressUp: _this12.onPressUp,
                onPan: _this12.onPan,
                direction: _reactHammerjs2.default.DIRECTION_HORIZONTAL
              },
              _react2.default.createElement(
                "div",
                { className: className, style: computedStyle },
                (0, _isFunction2.default)(children) ? children(interpolated.myProp) : children,
                !_this12.isClosed() && _react2.default.createElement(
                  _reactHammerjs2.default,
                  {
                    style: overlay,
                    className: overlayClassName,
                    onTap: _this12.onOverlayTap
                  },
                  _react2.default.createElement("span", null)
                )
              )
            )
          );
        }
      );
    }
  }]);

  return Drawer;
}(_react2.default.Component);

Drawer.propTypes = {
  zIndex: number, // z-index of the drawer default is 10000
  noTouchOpen: bool, // can a user pan to open
  noTouchClose: bool, // can a user pan to close
  onChange: func, // called when the drawer is open
  drawerStyle: object, // additional drawer styles
  className: string, // additional drawer className
  overlayClassName: string, // additional overlay className
  config: array, // configuration of the react-motion animation
  open: bool, // states if the drawer is open
  width: oneOfType([number, string]), // width of the drawer
  height: oneOfType([number, string]), // height of the drawer
  handleWidth: number, // width of the handle
  peakingWidth: number, // width that the drawer peaks on press
  panTolerance: number, // tolerance until the drawer starts to move
  right: bool, // drawer on the right side of the screen
  overlayColor: string, // color of the overlay
  fadeOut: bool, // fade out
  offset: number // offset
};
Drawer.defaultProps = {
  zIndex: 10000,
  noTouchOpen: false,
  noTouchClose: false,
  onChange: function onChange() {},
  overlayColor: "rgba(0, 0, 0, 0.4)",
  config: [350, 40],
  open: false,
  width: 300,
  height: "100%",
  handleWidth: 20,
  peakingWidth: 50,
  panTolerance: 50,
  right: false,
  fadeOut: false,
  offset: 0
};
var _default = Drawer;
exports.default = _default;
;

var _temp2 = function () {
  if (typeof __REACT_HOT_LOADER__ === 'undefined') {
    return;
  }

  __REACT_HOT_LOADER__.register(bool, "bool", "lib/drawer.jsx");

  __REACT_HOT_LOADER__.register(number, "number", "lib/drawer.jsx");

  __REACT_HOT_LOADER__.register(array, "array", "lib/drawer.jsx");

  __REACT_HOT_LOADER__.register(object, "object", "lib/drawer.jsx");

  __REACT_HOT_LOADER__.register(string, "string", "lib/drawer.jsx");

  __REACT_HOT_LOADER__.register(func, "func", "lib/drawer.jsx");

  __REACT_HOT_LOADER__.register(oneOfType, "oneOfType", "lib/drawer.jsx");

  __REACT_HOT_LOADER__.register(Drawer, "Drawer", "lib/drawer.jsx");

  __REACT_HOT_LOADER__.register(_default, "default", "lib/drawer.jsx");
}();

;