function _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

var Util = require('../util');

var CanvasTooltip = require('./canvas');

var _require = require('../const'),
    FONT_FAMILY = _require.FONT_FAMILY;

var DomUtil = Util.DomUtil;
var MatrixUtil = Util.MatrixUtil;

var MiniTooltip = /*#__PURE__*/function (_CanvasTooltip) {
  _inheritsLoose(MiniTooltip, _CanvasTooltip);

  function MiniTooltip() {
    return _CanvasTooltip.apply(this, arguments) || this;
  }

  var _proto = MiniTooltip.prototype;

  _proto.getDefaultCfg = function getDefaultCfg() {
    var cfg = _CanvasTooltip.prototype.getDefaultCfg.call(this);

    return Util.mix({}, cfg, {
      /**
       * 默认背景板样式
       * @type {Object}
       */
      boardStyle: {
        x: 0,
        y: 0,
        width: 0,
        height: 0,
        // fill: 'rgba(50, 50, 50, 1)',
        radius: 3
      },

      /**
       * 默认value样式
       * @type {Object}
       * */
      valueStyle: {
        x: 0,
        y: 0,
        text: '',
        fontFamily: FONT_FAMILY,
        fontSize: 12,
        stroke: '#fff',
        lineWidth: 2,
        fill: 'black',
        textBaseline: 'top',
        textAlign: 'start'
      },

      /**
       * 默认padding值
       * @type {Object}
       */
      padding: {
        top: 5,
        right: 5,
        bottom: 0,
        left: 5
      },
      triangleWidth: 10,
      triangleHeight: 4
    });
  };

  _proto._init_ = function _init_() {
    var self = this;
    var padding = self.get('padding');
    var parent = self.get('frontPlot'); // container

    var container = parent.addGroup();
    self.set('container', container); // board

    var board = container.addShape('rect', {
      attrs: Util.mix({}, self.get('boardStyle'))
    });
    self.set('board', board); // triangleShpe

    var triangleShape = container.addShape('path', {
      attrs: {
        fill: self.get('boardStyle').fill
      }
    });
    self.set('triangleShape', triangleShape); // itemGroup

    var itemGroup = container.addGroup();
    itemGroup.move(padding.left, padding.top); // value

    var valueShape = itemGroup.addShape('text', {
      attrs: Util.mix({}, self.get('valueStyle'))
    });
    self.set('valueShape', valueShape);
  };

  _proto.render = function render() {
    var self = this;
    self.clear();
    var board = self.get('board');
    var valueShape = self.get('valueShape');
    var padding = self.get('padding');
    var item = self.get('items')[0];

    if (valueShape) {
      valueShape.attr('text', item.value);
    } // update board based on bbox


    var bbox = valueShape ? valueShape.getBBox() : {
      width: 80,
      height: 30
    };
    var width = padding.left + bbox.width + padding.right;
    var height = padding.top + bbox.height + padding.bottom;
    board.attr('width', width);
    board.attr('height', height); // update triangle shape

    self._centerTriangleShape();
  };

  _proto.clear = function clear() {
    var valueShape = this.get('valueShape');
    valueShape.attr('text', '');
  };

  _proto.setPosition = function setPosition(x, y, target) {
    var self = this;
    var container = self.get('container');
    var plotRange = self.get('plotRange');
    var bbox = container.getBBox();
    var width = bbox.width;
    var height = bbox.height;
    x -= width / 2;

    if (target && (target.name === 'point' || target.name === 'interval')) {
      var targetY = target.getBBox().y;
      y = targetY;
    }

    y -= height;

    if (this.get('inPlot')) {
      // constrain in plot
      if (x < plotRange.tl.x) {
        x = plotRange.tl.x;

        self._leftTriangleShape();
      } else if (x + width / 2 > plotRange.tr.x) {
        x = plotRange.tr.x - width;

        self._rightTriangleShape();
      } else {
        self._centerTriangleShape();
      }

      if (y < plotRange.tl.y) {
        y = plotRange.tl.y;
      } else if (y + height > plotRange.bl.y) {
        y = plotRange.bl.y - height;
      }
    } else {
      // constrain in dom
      var outterNode = this.get('canvas').get('el');
      var viewWidth = DomUtil.getWidth(outterNode);
      var viewHeight = DomUtil.getHeight(outterNode);

      if (x < 0) {
        x = 0;

        self._leftTriangleShape();
      } else if (x + width / 2 > viewWidth) {
        x = viewWidth - width;

        self._rightTriangleShape();
      } else {
        self._centerTriangleShape();
      }

      if (y < 0) {
        y = 0;
      } else if (y + height > viewHeight) {
        y = viewHeight - height;
      }
    }

    var ulMatrix = [1, 0, 0, 0, 1, 0, 0, 0, 1];
    var mat = MatrixUtil.transform(ulMatrix, [['t', x, y]]);
    container.stopAnimate();
    container.animate({
      matrix: mat
    }, this.get('animationDuration'));
  };

  _proto._centerTriangleShape = function _centerTriangleShape() {
    var triangle = this.get('triangleShape');
    var width = this.get('triangleWidth');
    var height = this.get('triangleHeight');
    var boardBBox = this.get('board').getBBox();
    var boardWidth = boardBBox.width;
    var boardHeight = boardBBox.height;
    var pathArray = [['M', 0, 0], ['L', width, 0], ['L', width / 2, height], ['L', 0, 0], ['Z']];
    triangle.attr('path', pathArray);
    triangle.move(boardWidth / 2 - width / 2, boardHeight - 1);
  };

  _proto._leftTriangleShape = function _leftTriangleShape() {
    var triangle = this.get('triangleShape');
    var width = this.get('triangleWidth');
    var height = this.get('triangleHeight');
    var boardBBox = this.get('board').getBBox();
    var boardHeight = boardBBox.height;
    var pathArray = [['M', 0, 0], ['L', width, 0], ['L', 0, height + 3], ['L', 0, 0], ['Z']];
    triangle.attr('path', pathArray);
    triangle.move(0, boardHeight - 3);
  };

  _proto._rightTriangleShape = function _rightTriangleShape() {
    var triangle = this.get('triangleShape');
    var width = this.get('triangleWidth');
    var height = this.get('triangleHeight');
    var boardBBox = this.get('board').getBBox();
    var boardWidth = boardBBox.width;
    var boardHeight = boardBBox.height;
    var pathArray = [['M', 0, 0], ['L', width, 0], ['L', width, height + 4], ['L', 0, 0], ['Z']];
    triangle.attr('path', pathArray);
    triangle.move(boardWidth - width - 1, boardHeight - 4);
  };

  return MiniTooltip;
}(CanvasTooltip);

module.exports = MiniTooltip;