function _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

var Component = require('../component');

var Util = require('../util');

var Crosshair = /*#__PURE__*/function (_Component) {
  _inheritsLoose(Crosshair, _Component);

  var _proto = Crosshair.prototype;

  _proto.getDefaultCfg = function getDefaultCfg() {
    var cfg = _Component.prototype.getDefaultCfg.call(this);

    return Util.mix({}, cfg, {
      /**
        * crosshair的类型
        * @type {String}
        */
      type: null,

      /**
       * 画在哪层视图
       * @type {G-Element}
       */
      plot: null,

      /**
       * x轴上，移动到位置的偏移量
       * @type {Number}
       */
      plotRange: null,

      /**
       * 默认rect crosshair样式
       * @type {Object}
       */
      rectStyle: {
        fill: '#CCD6EC',
        opacity: 0.3
      },

      /**
        * 默认line crosshair样式
        * @type {Object}
        */
      lineStyle: {
        stroke: 'rgba(0, 0, 0, 0.25)',
        lineWidth: 1
      },
      isTransposed: false
    });
  };

  function Crosshair(cfg) {
    var _this;

    _this = _Component.call(this, cfg) || this;

    _this._init_();

    _this.render();

    return _this;
  }

  _proto._init_ = function _init_() {
    var self = this;
    var plot = self.get('plot');
    var group;

    if (self.type === 'rect') {
      group = plot.addGroup({
        zIndex: 0
      });
    } else {
      group = plot.addGroup();
    }

    this.set('container', group);
  };

  _proto._addLineShape = function _addLineShape(attrs, type) {
    var container = this.get('container');
    var shape = container.addShape('line', {
      capture: false,
      attrs: attrs
    }); // shape.hide();

    this.set('crossLineShape' + type, shape);
    return shape;
  };

  _proto._renderHorizontalLine = function _renderHorizontalLine(canvas, plotRange) {
    var style = Util.mix(this.get('lineStyle'), this.get('style'));
    var attrs = Util.mix({
      x1: plotRange ? plotRange.bl.x : canvas.get('width'),
      y1: 0,
      x2: plotRange ? plotRange.br.x : 0,
      y2: 0
    }, style);

    this._addLineShape(attrs, 'X');
  };

  _proto._renderVerticalLine = function _renderVerticalLine(canvas, plotRange) {
    var style = Util.mix(this.get('lineStyle'), this.get('style'));
    var attrs = Util.mix({
      x1: 0,
      y1: plotRange ? plotRange.bl.y : canvas.get('height'),
      x2: 0,
      y2: plotRange ? plotRange.tl.y : 0
    }, style);

    this._addLineShape(attrs, 'Y');
  };

  _proto._renderBackground = function _renderBackground(canvas, plotRange) {
    var style = Util.mix(this.get('rectStyle'), this.get('style'));
    var container = this.get('container');
    var attrs = Util.mix({
      x: plotRange ? plotRange.tl.x : 0,
      y: plotRange ? plotRange.tl.y : canvas.get('height'),
      width: plotRange ? plotRange.br.x - plotRange.bl.x : canvas.get('width'),
      height: plotRange ? Math.abs(plotRange.tl.y - plotRange.bl.y) : canvas.get('height')
    }, style);
    var shape = container.addShape('rect', {
      attrs: attrs,
      capture: false
    }); // shape.hide();

    this.set('crosshairsRectShape', shape);
    return shape;
  };

  _proto._updateRectShape = function _updateRectShape(items) {
    var offset;
    var crosshairsRectShape = this.get('crosshairsRectShape');
    var isTransposed = this.get('isTransposed');
    var firstItem = items[0];
    var lastItem = items[items.length - 1];
    var dim = isTransposed ? 'y' : 'x';
    var attr = isTransposed ? 'height' : 'width';
    var startDim = firstItem[dim];

    if (items.length > 1 && firstItem[dim] > lastItem[dim]) {
      startDim = lastItem[dim];
    }

    if (this.get('width')) {
      // 用户定义了 width
      crosshairsRectShape.attr(dim, startDim - this.get('crosshairs').width / 2);
      crosshairsRectShape.attr(attr, this.get('width'));
    } else {
      if (Util.isArray(firstItem.point[dim]) && !firstItem.size) {
        // 直方图
        var width = firstItem.point[dim][1] - firstItem.point[dim][0];
        crosshairsRectShape.attr(dim, firstItem.point[dim][0]);
        crosshairsRectShape.attr(attr, width);
      } else {
        offset = 3 * firstItem.size / 4;
        crosshairsRectShape.attr(dim, startDim - offset);

        if (items.length === 1) {
          crosshairsRectShape.attr(attr, 3 * firstItem.size / 2);
        } else {
          crosshairsRectShape.attr(attr, Math.abs(lastItem[dim] - firstItem[dim]) + 2 * offset);
        }
      }
    }
  };

  _proto.render = function render() {
    var canvas = this.get('canvas');
    var plotRange = this.get('plotRange');
    var isTransposed = this.get('isTransposed');
    this.clear();

    switch (this.get('type')) {
      case 'x':
        this._renderHorizontalLine(canvas, plotRange);

        break;

      case 'y':
        this._renderVerticalLine(canvas, plotRange);

        break;

      case 'cross':
        this._renderHorizontalLine(canvas, plotRange);

        this._renderVerticalLine(canvas, plotRange);

        break;

      case 'rect':
        this._renderBackground(canvas, plotRange);

        break;

      default:
        isTransposed ? this._renderHorizontalLine(canvas, plotRange) : this._renderVerticalLine(canvas, plotRange);
    }
  };

  _proto.show = function show() {
    var container = this.get('container');

    _Component.prototype.show.call(this);

    container.show();
  };

  _proto.hide = function hide() {
    var container = this.get('container');

    _Component.prototype.hide.call(this);

    container.hide();
  };

  _proto.clear = function clear() {
    var container = this.get('container');
    this.set('crossLineShapeX', null);
    this.set('crossLineShapeY', null);
    this.set('crosshairsRectShape', null);

    _Component.prototype.clear.call(this);

    container.clear();
  };

  _proto.destroy = function destroy() {
    var container = this.get('container');

    _Component.prototype.destroy.call(this);

    container.remove();
  };

  _proto.setPosition = function setPosition(x, y, items) {
    var crossLineShapeX = this.get('crossLineShapeX');
    var crossLineShapeY = this.get('crossLineShapeY');
    var crosshairsRectShape = this.get('crosshairsRectShape');

    if (crossLineShapeY && !crossLineShapeY.get('destroyed')) {
      // 第一次进入时，画布需要单独绘制，所以需要先设定corss的位置
      crossLineShapeY.move(x, 0);
    }

    if (crossLineShapeX && !crossLineShapeX.get('destroyed')) {
      crossLineShapeX.move(0, y);
    }

    if (crosshairsRectShape && !crosshairsRectShape.get('destroyed')) {
      this._updateRectShape(items);
    }
  };

  return Crosshair;
}(Component);

module.exports = Crosshair;