function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

var G = require('@antv/g/lib');

var Crosshair = require('./crosshair');

var MarkerGroupMixin = require('./mixin/marker-group');

var PositionMixin = require('./mixin/position');

var Tooltip = require('./base');

var Util = require('../util');

var _require = require('../const'),
    FONT_FAMILY = _require.FONT_FAMILY;

var DomUtil = Util.DomUtil;
var MatrixUtil = Util.MatrixUtil;

var CanvasTooltip = /*#__PURE__*/function (_Tooltip) {
  _inheritsLoose(CanvasTooltip, _Tooltip);

  var _proto = CanvasTooltip.prototype;

  _proto.getDefaultCfg = function getDefaultCfg() {
    var cfg = _Tooltip.prototype.getDefaultCfg.call(this);

    return Util.mix({}, cfg, {
      /**
       * 默认背景板样式
       * @type {Object}
       */
      boardStyle: {
        x: 0,
        y: 0,
        width: 100,
        height: 100,
        fill: 'rgba(255, 255, 255, 0.9)',
        radius: 4,
        stroke: '#e2e2e2',
        lineWidth: 1
      },

      /**
       * 默认title样式
       * @type {Object}
       */
      titleStyle: {
        fontFamily: FONT_FAMILY,
        text: '',
        textBaseline: 'top',
        fontSize: 12,
        fill: 'rgb(87, 87, 87)',
        lineHeight: 20,
        padding: 20
      },

      /**
       * 默认marker样式
       * @type {Object}
       */
      markerStyle: {
        radius: 4
      },

      /**
       * 默认name样式
       * @type {Object}
       */
      nameStyle: {
        fontFamily: FONT_FAMILY,
        fontSize: 12,
        fill: 'rgb(87, 87, 87)',
        textBaseline: 'middle',
        textAlign: 'start',
        padding: 8
      },

      /**
       * 默认value样式
       * @type {Object}
       */
      valueStyle: {
        fontFamily: FONT_FAMILY,
        fontSize: 12,
        fill: 'rgb(87, 87, 87)',
        textBaseline: 'middle',
        textAlign: 'start',
        padding: 30
      },

      /**
       * 默认padding值
       * @type {Object}
       */
      padding: {
        top: 20,
        right: 20,
        bottom: 20,
        left: 20
      },

      /**
       * 默认item之间的gap
       * @type {Number}
       */
      itemGap: 10,

      /**
       * 默认tooltip位置移动动画的时长
       * @type {Number}
       */
      animationDuration: 200
    });
  };

  function CanvasTooltip(cfg) {
    var _this;

    _this = _Tooltip.call(this, cfg) || this;
    Util.assign(_assertThisInitialized(_this), PositionMixin);
    Util.assign(_assertThisInitialized(_this), MarkerGroupMixin); // crosshair

    var crosshair = _this.get('crosshairs');

    if (crosshair) {
      var plot = crosshair.type === 'rect' ? _this.get('backPlot') : _this.get('frontPlot');
      var crosshairGroup = new Crosshair(Util.mix({
        plot: plot,
        plotRange: _this.get('plotRange'),
        canvas: _this.get('canvas')
      }, _this.get('crosshairs')));
      crosshairGroup.hide();

      _this.set('crosshairGroup', crosshairGroup);
    }

    _this._init_();

    if (_this.get('items')) {
      _this.render();
    }

    return _this;
  }

  _proto._init_ = function _init_() {
    var self = this;
    var padding = self.get('padding');
    var parent = self.get('frontPlot'); // marker group

    var markerGroup = parent.addGroup({
      capture: false
    });
    self.set('markerGroup', markerGroup); // container

    var container = parent.addGroup();
    container.hide();
    self.set('container', container); // board

    var board = container.addShape('rect', {
      attrs: Util.mix({}, self.get('boardStyle'))
    });
    self.set('board', board); // title

    var titleStyle = self.get('titleStyle');

    if (self.get('showTitle')) {
      var titleShape = container.addShape('text', {
        attrs: Util.mix({
          x: padding.left,
          y: padding.top
        }, titleStyle)
      });
      self.set('titleShape', titleShape);
      titleShape.name = 'tooltip-title';
    } // items


    var itemsGroup = container.addGroup();
    itemsGroup.move(padding.left, padding.top + titleStyle.lineHeight + titleStyle.padding);
    self.set('itemsGroup', itemsGroup);
  };

  _proto.render = function render() {
    var self = this;
    self.clear();
    var container = self.get('container');
    var board = self.get('board');
    var showTitle = self.get('showTitle');
    var titleContent = self.get('titleContent');
    var titleShape = this.get('titleShape');
    var itemsGroup = this.get('itemsGroup');
    var items = self.get('items');
    var padding = self.get('padding');

    if (titleShape && showTitle) {
      titleShape.attr('text', titleContent);
    }

    if (itemsGroup) {
      var itemGap = self.get('itemGap');
      var x = 0;
      var y = 0;
      Util.each(items, function (item) {
        var itemGroup = self._addItem(item);

        itemGroup.move(x, y);
        itemsGroup.add(itemGroup);
        var itemHeight = itemGroup.getBBox().height;
        y += itemHeight + itemGap;
      });
    } // update board based on bbox


    var bbox = container.getBBox();
    var width = bbox.width + padding.right;
    var height = bbox.height + padding.bottom;
    board.attr('width', width);
    board.attr('height', height); // align value text to right

    self._alignToRight(width);
  };

  _proto.clear = function clear() {
    var titleShape = this.get('titleShape');
    var itemsGroup = this.get('itemsGroup');
    var board = this.get('board');
    titleShape.text = '';
    itemsGroup.clear();
    board.attr('width', 0);
    board.attr('height', 0);
  };

  _proto.show = function show() {
    var container = this.get('container');
    container.show();
    var crosshairGroup = this.get('crosshairGroup');
    crosshairGroup && crosshairGroup.show();
    var markerGroup = this.get('markerGroup');
    markerGroup && markerGroup.show();

    _Tooltip.prototype.show.call(this);

    this.get('canvas').draw();
  };

  _proto.hide = function hide() {
    var container = this.get('container');
    container.hide();
    var crosshairGroup = this.get('crosshairGroup');
    crosshairGroup && crosshairGroup.hide();
    var markerGroup = this.get('markerGroup');
    markerGroup && markerGroup.hide();

    _Tooltip.prototype.hide.call(this);

    this.get('canvas').draw();
  };

  _proto.destroy = function destroy() {
    var container = this.get('container');
    var crosshairGroup = this.get('crosshairGroup');
    crosshairGroup && crosshairGroup.destroy();
    var markerGroup = this.get('markerGroup');
    markerGroup && markerGroup.remove();

    _Tooltip.prototype.destroy.call(this);

    container.remove();
  };

  _proto.setPosition = function setPosition(x, y, target) {
    var container = this.get('container');
    var outterNode = this.get('canvas').get('el');
    var viewWidth = DomUtil.getWidth(outterNode);
    var viewHeight = DomUtil.getHeight(outterNode);
    var bbox = container.getBBox();
    var containerWidth = bbox.width;
    var containerHeight = bbox.height;
    var endx = x;
    var endy = y;
    var position;

    if (this.get('position')) {
      var _containerWidth = bbox.width;
      var _containerHeight = bbox.height;
      position = this._calcTooltipPosition(x, y, this.get('position'), _containerWidth, _containerHeight, target);
      x = position[0];
      y = position[1];
    } else {
      position = this._constraintPositionInBoundary(x, y, containerWidth, containerHeight, viewWidth, viewHeight);
      x = position[0];
      y = position[1];
    }

    if (this.get('inPlot')) {
      // tooltip 必须限制在绘图区域内
      var plotRange = this.get('plotRange');
      position = this._constraintPositionInPlot(x, y, containerWidth, containerHeight, plotRange, this.get('enterable'));
      x = position[0];
      y = position[1];
    }

    var markerItems = this.get('markerItems');

    if (!Util.isEmpty(markerItems)) {
      endx = markerItems[0].x;
      endy = markerItems[0].y;
    }

    var ulMatrix = [1, 0, 0, 0, 1, 0, 0, 0, 1];
    var mat = MatrixUtil.transform(ulMatrix, [['t', x, y]]);
    container.stopAnimate();
    container.animate({
      matrix: mat
    }, this.get('animationDuration'));
    var crosshairGroup = this.get('crosshairGroup');

    if (crosshairGroup) {
      var items = this.get('items');
      crosshairGroup.setPosition(endx, endy, items);
    }

    _Tooltip.prototype.setPosition.call(this, x, y);
  };

  _proto._addItem = function _addItem(item) {
    var group = new G.Group();
    var markerRadius = this.get('markerStyle').radius; // marker

    if (item.marker) {
      var markerAttrs = Util.mix({}, item.marker, {
        x: item.marker.radius / 2,
        y: 0,
        symbol: item.marker.activeSymbol || item.marker.symbol
      });
      group.addShape('marker', {
        attrs: markerAttrs
      });
      markerRadius = item.marker.radius;
    } // name


    var nameStyle = this.get('nameStyle');
    group.addShape('text', {
      attrs: Util.mix({
        x: markerRadius + nameStyle.padding,
        y: 0,
        text: item.name
      }, nameStyle)
    }); // value

    var valueStyle = this.get('valueStyle');
    group.addShape('text', {
      attrs: Util.mix({
        x: group.getBBox().width + valueStyle.padding,
        y: 0,
        text: item.value
      }, valueStyle)
    });
    return group;
  };

  _proto._alignToRight = function _alignToRight(width) {
    var _this2 = this;

    var itemsGroup = this.get('itemsGroup');
    var groups = itemsGroup.get('children');
    Util.each(groups, function (g) {
      var children = g.get('children');
      var valueText = children[2];
      var w = valueText.getBBox().width;
      var x = width - w - _this2.get('padding').right * 2;
      valueText.attr('x', x);
    });
  };

  return CanvasTooltip;
}(Tooltip);

module.exports = CanvasTooltip;