function _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

var Component = require('../base');

var Util = require('../util');

var Tooltip = /*#__PURE__*/function (_Component) {
  _inheritsLoose(Tooltip, _Component);

  function Tooltip() {
    return _Component.apply(this, arguments) || this;
  }

  var _proto = Tooltip.prototype;

  _proto.getDefaultCfg = function getDefaultCfg() {
    var cfg = _Component.prototype.getDefaultCfg.call(this);

    return Util.mix({}, cfg, {
      /**
       * tooltip container
       * @type {Dom / String}
       */

      /**
       * 右下角坐标
       * @type {Number}
       */
      x: 0,

      /**
       * y 右下角坐标
       * @type {Number}
       */
      y: 0,

      /**
       * tooltip 记录项
       * @type {Array}
       */
      items: null,

      /**
       * tooltip 标题
       * @type {Array}
       */
      titleContent: null,

      /**
       * 是否展示 title
       * @type {Boolean}
       */
      showTitle: true,

      /**
       * 视图范围
       * @type {Object}
       */
      plotRange: null,

      /**
       * x轴上，移动到位置的偏移量
       * @type {Number}
       */
      offset: 10,
      // TODO:支持xy两个方向上的offset

      /**
       * 时间戳
       * @type {Number}
       */
      timeStamp: 0,

      /**
       * 将 tooltip 展示在指定区域内
       * @type {Boolean}
       */
      inPlot: true,

      /**
       * tooltip 辅助线配置
       * @type {Object}
       */
      crosshairs: null
    });
  };

  _proto.isContentChange = function isContentChange(title, items) {
    var titleContent = this.get('titleContent');
    var lastItems = this.get('items');
    var isChanged = !(title === titleContent && lastItems.length === items.length);

    if (!isChanged) {
      Util.each(items, function (item, index) {
        var preItem = lastItems[index];

        for (var key in item) {
          if (item.hasOwnProperty(key)) {
            if (!Util.isObject(item[key]) && item[key] !== preItem[key]) {
              isChanged = true;
              break;
            }
          }
        }

        if (isChanged) {
          return false;
        }
      });
    }

    return isChanged;
  };

  _proto.setContent = function setContent(title, items) {
    var timeStamp = new Date().valueOf();
    this.set('items', items);
    this.set('titleContent', title);
    this.set('timeStamp', timeStamp);
    this.render();
    return this;
  };

  _proto.setPosition = function setPosition(x, y) {
    this.set('x', x);
    this.set('y', y);
  };

  _proto.render = function render() {};

  _proto.clear = function clear() {};

  _proto.show = function show() {
    this.set('visible', true);
  };

  _proto.hide = function hide() {
    this.set('visible', false);
  };

  return Tooltip;
}(Component);

module.exports = Tooltip;