function _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

/**
 * @fileOverview The class of the gradient color legend
 * @author sima.zhang
 */
var Util = require('../util');

var Continuous = require('./continuous');

var Size = /*#__PURE__*/function (_Continuous) {
  _inheritsLoose(Size, _Continuous);

  function Size() {
    return _Continuous.apply(this, arguments) || this;
  }

  var _proto = Size.prototype;

  _proto.getDefaultCfg = function getDefaultCfg() {
    var cfg = _Continuous.prototype.getDefaultCfg.call(this);

    return Util.mix({}, cfg, {
      /**
       * 类型
       * @type {String}
       */
      type: 'size-legend',
      width: 100,
      height: 200,

      /**
       * 不能滑动时圈的样式
       * @type {ATTRS}
       */
      _unslidableElementStyle: {
        fill: '#4E7CCC',
        fillOpacity: 1
      },

      /**
       * 中间 bar 的前景颜色
       * @type {ATTRS}
       */
      frontMiddleBarStyle: {
        fill: 'rgb(64, 141, 251)'
      }
    });
  } // render the slider shape
  ;

  _proto._renderSliderShape = function _renderSliderShape() {
    var slider = this.get('slider');
    var backgroundElement = slider.get('backgroundElement');
    var layout = this.get('layout');
    var width = this.get('width');
    var height = this.get('height'); // const x = minRadius;

    var y = this.get('height') / 2;
    var frontMiddleBarStyle = this.get('frontMiddleBarStyle'); // background of middle bar

    var points = layout === 'vertical' ? [[0, 0], [width, 0], [width, height], [width - 4, height]] : [[0, y + height / 2], [0, y + height / 2 - 4], [width, y - height / 2], [width, y + height / 2]];
    return this._addMiddleBar(backgroundElement, 'Polygon', Util.mix({
      points: points
    }, frontMiddleBarStyle));
  } // render the middle bar while slidable === false,
  // there are no triggers for this situation
  ;

  _proto._renderUnslidable = function _renderUnslidable() {
    var layout = this.get('layout');
    var width = this.get('width');
    var height = this.get('height');
    var frontMiddleBarStyle = this.get('frontMiddleBarStyle');
    var points = layout === 'vertical' ? [[0, 0], [width, 0], [width, height], [width - 4, height]] : [[0, height], [0, height - 4], [width, 0], [width, height]];
    var group = this.get('group');
    var bgGroup = group.addGroup();
    bgGroup.addShape('Polygon', {
      attrs: Util.mix({
        points: points
      }, frontMiddleBarStyle)
    });

    var minText = this._formatItemValue(this.get('firstItem').value);

    var maxText = this._formatItemValue(this.get('lastItem').value);

    if (this.get('layout') === 'vertical') {
      this._addText(width + 10, height - 3, minText); // min


      this._addText(width + 10, 3, maxText); // max

    } else {
      this._addText(0, height, minText); // min


      this._addText(width, height, maxText); // max

    }
  } // add min and max text while slidable === false
  ;

  _proto._addText = function _addText(x, y, text) {
    var group = this.get('group');
    var textGroup = group.addGroup();
    var textStyle = this.get('textStyle');
    var titleShape = this.get('titleShape');
    var titleGap = this.get('titleGap');

    if (titleShape) {
      titleGap += titleShape.getBBox().height;
    }

    if (this.get('layout') === 'vertical') {
      textGroup.addShape('text', {
        attrs: Util.mix({
          x: x + this.get('textOffset'),
          y: y,
          text: text === 0 ? '0' : text
        }, textStyle)
      });
    } else {
      y += titleGap + this.get('textOffset') - 20;
      if (!titleShape) y += 10;
      textGroup.addShape('text', {
        attrs: Util.mix({
          x: x,
          y: y,
          text: text === 0 ? '0' : text
        }, textStyle)
      });
    }
  };

  return Size;
}(Continuous);

module.exports = Size;