function _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

/**
 * @fileOverview The class of the size legend
 * @author sima.zhang
 * @author ye liu
 */
var Util = require('../util'); // const Global = require('../../global');


var Continuous = require('./continuous');

var SLIDER_HEIGHT = 2;
var CIRCLE_GAP = 16;
var MAX_SIZE = 16;
var MIN_SIZE = 5;

var CircleSize = /*#__PURE__*/function (_Continuous) {
  _inheritsLoose(CircleSize, _Continuous);

  function CircleSize() {
    return _Continuous.apply(this, arguments) || this;
  }

  var _proto = CircleSize.prototype;

  _proto.getDefaultCfg = function getDefaultCfg() {
    var cfg = _Continuous.prototype.getDefaultCfg.call(this);

    return Util.mix({}, cfg, {
      /**
       * 类型
       * @type {String}
       */
      type: 'size-circle-legend',
      width: 100,
      height: 200,

      /**
       * 不能滑动时圈的样式
       * @type {ATTRS}
       */
      _unslidableCircleStyle: {
        stroke: 'rgb(99, 161, 248)',
        fill: 'rgb(99, 161, 248)',
        fillOpacity: 0.3,
        lineWidth: 1.5
      },

      /**
       * 滑块的样式
       * @type {ATTRS}
       */
      triggerAttr: {
        fill: 'white',
        shadowOffsetX: -2,
        shadowOffsetY: 2,
        shadowBlur: 10,
        shadowColor: '#ccc'
      },

      /**
       * 中间 bar 的前景颜色
       * @type {ATTRS}
       */
      frontMiddleBarStyle: {
        fill: 'rgb(64, 141, 251)'
      }
    });
  } // render the slider shape
  ;

  _proto._renderSliderShape = function _renderSliderShape() {
    var minRadius = MIN_SIZE;
    var slider = this.get('slider');
    var backgroundElement = slider.get('backgroundElement');
    var layout = this.get('layout');
    var width = layout === 'vertical' ? SLIDER_HEIGHT : this.get('width');
    var height = layout === 'vertical' ? this.get('height') : SLIDER_HEIGHT;
    var x = minRadius;
    var y = this.get('height') / 2;
    var frontMiddleBarStyle = this.get('frontMiddleBarStyle'); // background of middle bar

    var points = layout === 'vertical' ? [[0, 0], [width, 0], [width, height], [0, height]] : [[0, y + height], [0, y - height], [x + width - 4, y - height], [x + width - 4, y + height]];
    return this._addMiddleBar(backgroundElement, 'Polygon', Util.mix({
      points: points
    }, frontMiddleBarStyle));
  } // triggers while layout === horizontal
  ;

  _proto._addHorizontalTrigger = function _addHorizontalTrigger(type, blockAttr, textAttr, radius) {
    var slider = this.get('slider');
    var trigger = slider.get(type + 'HandleElement');
    var y = -this.get('height') / 2;
    var button = trigger.addShape('circle', {
      attrs: Util.mix({
        x: 0,
        y: y,
        r: radius
      }, blockAttr)
    });
    var text = trigger.addShape('text', {
      attrs: Util.mix(textAttr, {
        x: 0,
        y: y + radius + 10,
        textAlign: 'center',
        textBaseline: 'middle'
      })
    });
    var layout = this.get('layout');
    var trigerCursor = layout === 'vertical' ? 'ns-resize' : 'ew-resize';
    button.attr('cursor', trigerCursor);
    text.attr('cursor', trigerCursor);
    this.set(type + 'ButtonElement', button);
    this.set(type + 'TextElement', text);
  } // triggers while layout === vertical
  ;

  _proto._addVerticalTrigger = function _addVerticalTrigger(type, blockAttr, textAttr, radius) {
    var slider = this.get('slider');
    var trigger = slider.get(type + 'HandleElement');
    var button = trigger.addShape('circle', {
      attrs: Util.mix({
        x: 0,
        y: 0,
        r: radius
      }, blockAttr)
    });
    var text = trigger.addShape('text', {
      attrs: Util.mix(textAttr, {
        x: radius + 10,
        y: 0,
        textAlign: 'start',
        textBaseline: 'middle'
      })
    });
    var layout = this.get('layout');
    var trigerCursor = layout === 'vertical' ? 'ns-resize' : 'ew-resize';
    button.attr('cursor', trigerCursor);
    text.attr('cursor', trigerCursor);
    this.set(type + 'ButtonElement', button);
    this.set(type + 'TextElement', text);
  } // render the triggers
  ;

  _proto._renderTrigger = function _renderTrigger() {
    var min = this.get('firstItem');
    var max = this.get('lastItem');
    var layout = this.get('layout');
    var textStyle = this.get('textStyle');
    var triggerAttr = this.get('triggerAttr');
    var minBlockAttr = Util.mix({}, triggerAttr);
    var maxBlockAttr = Util.mix({}, triggerAttr);
    var minRadius = MIN_SIZE;
    var maxRadius = MAX_SIZE;
    var minTextAttr = Util.mix({
      text: this._formatItemValue(min.value) + ''
    }, textStyle);
    var maxTextAttr = Util.mix({
      text: this._formatItemValue(max.value) + ''
    }, textStyle);

    if (layout === 'vertical') {
      this._addVerticalTrigger('min', minBlockAttr, minTextAttr, minRadius);

      this._addVerticalTrigger('max', maxBlockAttr, maxTextAttr, maxRadius);
    } else {
      this._addHorizontalTrigger('min', minBlockAttr, minTextAttr, minRadius);

      this._addHorizontalTrigger('max', maxBlockAttr, maxTextAttr, maxRadius);
    }
  } // user interactions
  ;

  _proto._bindEvents = function _bindEvents() {
    var _this = this;

    if (this.get('slidable')) {
      var slider = this.get('slider');
      slider.on('sliderchange', function (ev) {
        var range = ev.range;

        var firstItemValue = _this.get('firstItem').value;

        var lastItemValue = _this.get('lastItem').value;

        var minValue = firstItemValue + range[0] / 100 * (lastItemValue - firstItemValue);
        var maxValue = firstItemValue + range[1] / 100 * (lastItemValue - firstItemValue);
        var minRadius = MIN_SIZE + range[0] / 100 * (MAX_SIZE - MIN_SIZE);
        var maxRadius = MIN_SIZE + range[1] / 100 * (MAX_SIZE - MIN_SIZE);

        _this._updateElement(minValue, maxValue, minRadius, maxRadius);

        var itemFiltered = new Event('itemfilter', ev, true, true);
        itemFiltered.range = [minValue, maxValue];

        _this.emit('itemfilter', itemFiltered);
      });
    }
  } // update the triggers
  ;

  _proto._updateElement = function _updateElement(min, max, minR, maxR) {
    // update the text of the triggers
    _Continuous.prototype._updateElement.call(this, min, max);

    var minTextElement = this.get('minTextElement');
    var maxTextElement = this.get('maxTextElement');
    var minCircleElement = this.get('minButtonElement');
    var maxCircleElement = this.get('maxButtonElement'); // update the radius of the triggers

    minCircleElement.attr('r', minR);
    maxCircleElement.attr('r', maxR); // update the text position of the triggers

    var layout = this.get('layout');

    if (layout === 'vertical') {
      minTextElement.attr('x', minR + 10);
      maxTextElement.attr('x', maxR + 10);
    } else {
      var y = -this.get('height') / 2;
      minTextElement.attr('y', y + minR + 10);
      maxTextElement.attr('y', y + maxR + 10);
    }
  } // add a circle for slidable === false
  ;

  _proto._addCircle = function _addCircle(x, y, r, text, maxWidth) {
    var group = this.get('group');
    var circleGroup = group.addGroup();
    var circleStyle = this.get('_unslidableCircleStyle');
    var textStyle = this.get('textStyle');
    var titleShape = this.get('titleShape');
    var titleGap = this.get('titleGap');

    if (titleShape) {
      titleGap += titleShape.getBBox().height;
    }

    circleGroup.addShape('circle', {
      attrs: Util.mix({
        x: x,
        y: y + titleGap,
        r: r === 0 ? 1 : r
      }, circleStyle)
    });

    if (this.get('layout') === 'vertical') {
      circleGroup.addShape('text', {
        attrs: Util.mix({
          x: maxWidth + 20 + this.get('textOffset'),
          y: y + titleGap,
          text: text === 0 ? '0' : text
        }, textStyle)
      });
    } else {
      circleGroup.addShape('text', {
        attrs: Util.mix({
          x: x,
          y: y + titleGap + maxWidth + 13 + this.get('textOffset'),
          text: text === 0 ? '0' : text
        }, textStyle)
      });
    }
  } // the circles while slidable === false
  ;

  _proto._renderUnslidable = function _renderUnslidable() {
    var firstItemValue = this.get('firstItem').value;
    var lastItemValue = this.get('lastItem').value;

    if (firstItemValue > lastItemValue) {
      var tmp = lastItemValue;
      lastItemValue = firstItemValue;
      firstItemValue = tmp;
    }

    var minText = this._formatItemValue(firstItemValue);

    var maxText = this._formatItemValue(lastItemValue);

    var minRadius = firstItemValue < MIN_SIZE ? MIN_SIZE : firstItemValue;
    var maxRadius = lastItemValue > MAX_SIZE ? MAX_SIZE : lastItemValue;

    if (minRadius > maxRadius) {
      minRadius = MIN_SIZE;
      maxRadius = MAX_SIZE;
    }

    if (this.get('layout') === 'vertical') {
      this._addCircle(maxRadius, maxRadius, minRadius, minText, 2 * maxRadius); // min


      this._addCircle(maxRadius, maxRadius * 2 + CIRCLE_GAP + minRadius, maxRadius, maxText, 2 * maxRadius); // max

    } else {
      this._addCircle(maxRadius, maxRadius, minRadius, minText, 2 * maxRadius); // min


      this._addCircle(maxRadius * 2 + CIRCLE_GAP + minRadius, maxRadius, maxRadius, maxText, 2 * maxRadius); // max

    }
  };

  _proto.activate = function activate(value) {
    if (!this.get('slidable')) {
      return;
    }

    _Continuous.prototype.activate.call(this, value);
  };

  return CircleSize;
}(Continuous);

module.exports = CircleSize;