function _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

/**
 * @fileOverview The class of the gradient color legend
 * @author sima.zhang
 */
var _require = require('@antv/attr/lib'),
    ColorUtil = _require.ColorUtil; // TODO：ColorUtil 包需要从 attr 包中抽离


var Util = require('../util');

var Continuous = require('./continuous');

var Color = /*#__PURE__*/function (_Continuous) {
  _inheritsLoose(Color, _Continuous);

  function Color() {
    return _Continuous.apply(this, arguments) || this;
  }

  var _proto = Color.prototype;

  _proto.getDefaultCfg = function getDefaultCfg() {
    var cfg = _Continuous.prototype.getDefaultCfg.call(this);

    return Util.mix({}, cfg, {
      /**
       * 类型
       * @type {String}
       */
      type: 'color-legend',

      /**
       * 布局方式
       * horizontal 水平
       * vertical 垂直
       * @type {String}
       */
      layout: 'vertical',

      /**
       * 两头滑块的样式
       * @type {object}
       */
      triggerAttr: {
        fill: '#fff',
        shadowOffsetX: -2,
        shadowOffsetY: 2,
        shadowBlur: 10,
        shadowColor: '#ccc',
        radius: 3
      },

      /**
       * 同一分段是否使用相同颜色而不使用渐变色，在 slidable = false 时生效
       * @type {boolean}
       */
      isSegment: false
    });
  };

  _proto._setPercentage = function _setPercentage() {
    var items = this.get('items');
    if (items[0].percentage) return;
    var min = items[0].value;
    var max = items[items.length - 1].value;
    Util.each(items, function (it) {
      it.percentage = (it.value - min) / (max - min);
    });
    return;
  } // render the slider while slidable === true
  ;

  _proto._renderSliderShape = function _renderSliderShape() {
    this._setPercentage();

    var slider = this.get('slider');
    var backgroundElement = slider.get('backgroundElement');
    var width = this.get('width');
    var height = this.get('height');
    var layout = this.get('layout');
    var items = this.get('items');
    var fill = '';
    var rgbColor; // gradient color distributed according to the percentage

    if (layout === 'vertical') {
      fill += 'l (90) ';
      Util.each(items, function (v) {
        rgbColor = ColorUtil.toRGB(v.color);
        fill += 1 - v.percentage + ':' + rgbColor + ' ';
      });
    } else {
      fill += 'l (0) ';
      Util.each(items, function (v) {
        rgbColor = ColorUtil.toRGB(v.color);
        fill += v.percentage + ':' + rgbColor + ' ';
      });
    }

    return this._addMiddleBar(backgroundElement, 'Rect', {
      x: 0,
      y: 0,
      width: width,
      height: height,
      fill: fill,
      strokeOpacity: 0
    });
  } // render the silder while slidable === false
  ;

  _proto._renderUnslidable = function _renderUnslidable() {
    this._setPercentage();

    var titleShape = this.get('titleShape');
    var titleGap = this.get('titleGap');
    titleGap = titleShape ? titleShape.getBBox().height + titleGap : titleGap;
    var width = this.get('width');
    var height = this.get('height');
    var layout = this.get('layout');
    var items = this.get('items');
    var fill = '';
    var rgbColor;
    var path = [];
    var group = this.get('group');
    var bgGroup = group.addGroup();
    var isize = items.length; // gradient color distributed according to the percentage

    if (layout === 'vertical') {
      fill += 'l (90) ';

      for (var i = 0; i < isize; i += 1) {
        if (i !== 0 && i !== isize - 1) {
          path.push(['M', 0, height - items[i].percentage * height]);
          path.push(['L', width, height - items[i].percentage * height]);
        }

        rgbColor = ColorUtil.toRGB(items[i].color);
        fill += 1 - items[i].percentage + ':' + rgbColor + ' ';

        if (this.get('isSegment') && i > 0) {
          // one color instead of gradient color for a block while isSegment === true
          var preRgbColor = ColorUtil.toRGB(items[i - 1].color);
          fill += 1 - items[i].percentage + ':' + preRgbColor + ' ';
        }

        bgGroup.addShape('text', {
          attrs: Util.mix({}, {
            x: width + this.get('textOffset') / 2,
            y: height - items[i].percentage * height,
            text: this._formatItemValue(items[i].value) + '' // 以字符串格式展示

          }, this.get('textStyle'), {
            textAlign: 'start'
          })
        });
      }
    } else {
      // horizontal
      fill += 'l (0) ';

      for (var _i = 0; _i < isize; _i += 1) {
        if (_i !== 0 && _i !== isize - 1) {
          path.push(['M', items[_i].percentage * width, 0]);
          path.push(['L', items[_i].percentage * width, height]);
        }

        rgbColor = ColorUtil.toRGB(items[_i].color);

        if (this.get('isSegment') && _i > 0) {
          var _preRgbColor = ColorUtil.toRGB(items[_i - 1].color);

          fill += items[_i].percentage + ':' + _preRgbColor + ' ';
        }

        fill += items[_i].percentage + ':' + rgbColor + ' ';
        bgGroup.addShape('text', {
          attrs: Util.mix({}, {
            x: items[_i].percentage * width,
            y: height + 5 + this.get('textOffset'),
            text: this._formatItemValue(items[_i].value) + '' // 以字符串格式展示

          }, this.get('textStyle'))
        });
      }
    }

    bgGroup.addShape('rect', {
      attrs: {
        x: 0,
        y: 0,
        width: width,
        height: height,
        fill: fill,
        strokeOpacity: 0
      }
    }); // the white line segment to seperate color blocks

    bgGroup.addShape('path', {
      attrs: Util.mix({
        path: path
      }, this.get('lineStyle'))
    });
    bgGroup.move(0, titleGap);
  };

  return Color;
}(Continuous);

module.exports = Color;