function _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

var Util = require('../util');

var Legend = require('./base');

var _require = require('../const'),
    FONT_FAMILY = _require.FONT_FAMILY; // const DomUtil = Util.DomUtil;


var Event = Util.Event;
var Group = Util.Group; // const Global = require('../../global');
// const CONTAINER_CLASS = 'g2-legend';

function findItem(items, refer) {
  var rst = null;
  var value = refer instanceof Group || refer.name === 'legendGroup' ? refer.get('value') : refer;
  Util.each(items, function (item) {
    if (item.value === value) {
      rst = item;
      return false;
    }
  });
  return rst;
}

function findShapeByName(group, name) {
  return group.findBy(function (node) {
    return node.name === name;
  });
}

var Category = /*#__PURE__*/function (_Legend) {
  _inheritsLoose(Category, _Legend);

  function Category() {
    return _Legend.apply(this, arguments) || this;
  }

  var _proto = Category.prototype;

  _proto.getDefaultCfg = function getDefaultCfg() {
    var cfg = _Legend.prototype.getDefaultCfg.call(this);

    return Util.mix({}, cfg, {
      /**
       * type标识
       * @type {String}
       */
      type: 'category-legend',

      /**
       * 子项集合
       * @type {Array}
       */
      items: null,

      /**
       * TODO：rename
       * 图例项水平方向的间距
       * @type {Number}
       */
      itemGap: 5,

      /**
       * TODO：rename
       * 图例项垂直方向的间距
       * @type {Number}
       */
      itemMarginBottom: 8,

      /**
       * 图例项图组
       * @type {Group}
       */
      itemsGroup: null,

      /**
       * 布局方式： horizontal，vertical
       * @type {String}
       */
      layout: 'horizontal',

      /**
       * 是否允许全部取消，默认 false，即必须保留一个被选中
       * @type {Boolean}
       */
      allowAllCanceled: false,

      /**
       * 边框内边距
       * @type {Array}
       */
      backPadding: [0, 0, 0, 0],

      /**
       * 图例项取消选中的颜色
       * @type {String}
       */
      unCheckColor: '#ccc',

      /**
       * 图例背景层属性设置
       * @type {Obejct}
       */
      background: {
        fill: '#fff',
        fillOpacity: 0
      },

      /**
       * 图例项的宽度，当图例有很多图例项，并且用户想要这些图例项在同一平面内垂直对齐，此时这个属性可帮用户实现此效果
       * @type {Number}
       */
      itemWidth: null,

      /**
       * 图例文字样式
       * @type {ATTRS}
       */
      textStyle: {
        fill: '#333',
        fontSize: 12,
        textAlign: 'start',
        textBaseline: 'middle',
        fontFamily: FONT_FAMILY
      },

      /**
       * marker 和文字的距离
       * @type {Number}
       */
      _wordSpaceing: 8,

      /**
       * 图例项是否可点击，默认为 true
       * @type {Boolean}
       */
      clickable: true,

      /**
       * TODO: rename
       * 图例项的选择模式，多选和单选 multiple、single
       * @type {String}
       */
      selectedMode: 'multiple',

      /**
       * 图例项的顺序是否要逆序，默认为 false
       * @type {Boolean}
       */
      reversed: false,

      /**
       * 是否自动换行
       * @type {Boolean}
       */
      autoWrap: true,

      /**
       * 是否以增加 border 的方式高亮 hover 的 item。若为 false ，则降低其他 item 的透明度。
       * @type {Boolean}
       */
      highlight: false,

      /**
       * 非highlight方式下，鼠标hover到legend样式
       * @type {Number}
       */
      activeOpacity: 0.7,

      /**
       * 非highlight方式下，非鼠标hover到的legend样式
       * @type {Number}
       */
      inactiveOpacity: 1
    });
  } // rendering
  ;

  _proto.render = function render() {
    _Legend.prototype.render.call(this);

    this._renderItems();

    this.get('autoWrap') && this._adjustItems(); // 默认自动换行
  } // user iteraction
  ;

  _proto._bindEvents = function _bindEvents() {
    if (this.get('hoverable')) {
      this.get('group').on('mousemove', Util.wrapBehavior(this, '_onMousemove'));
      this.get('group').on('mouseleave', Util.wrapBehavior(this, '_onMouseleave'));
    }

    if (this.get('clickable')) {
      this.get('group').on('click', Util.wrapBehavior(this, '_onClick'));
    }
  } // return the target's parent legend object
  ;

  _proto._getLegendItem = function _getLegendItem(target) {
    var item = target.get('parent');

    if (item && item.name === 'legendGroup') {
      return item;
    }

    return null;
  } // activate an item by reduce the opacity of other items.
  // it is reserved for bi-direction interaction between charts / graph and legend
  ;

  _proto.activate = function activate(value) {
    var _this = this;

    var self = this;
    var itemsGroup = self.get('itemsGroup');
    var children = itemsGroup.get('children');
    var markerItem = void 0;
    children.forEach(function (child) {
      markerItem = findShapeByName(child, 'legend-marker');
      if (!markerItem) return;
      var checked = child.get('checked');

      if (_this.get('highlight')) {
        // change stroke color
        if (child.get('value') === value && checked) {
          markerItem.attr('stroke', '#333');
        } else {
          markerItem.attr('stroke', null);
        }
      } else {
        // change opacity
        if (child.get('value') === value) {
          markerItem.attr('fillOpacity', self.get('activeOpacity'));
        }
      }
    });
    this.get('canvas').draw();
    return;
  } // restore the opacity of items
  // it is reserved for bi-direction interaction between charts / graph and legend
  ;

  _proto.deactivate = function deactivate() {
    var _this2 = this;

    var self = this;
    var itemsGroup = self.get('itemsGroup');
    var children = itemsGroup.get('children');
    var markerItem = void 0;
    var unCheckColor = this.get('unCheckColor');
    children.forEach(function (child) {
      markerItem = findShapeByName(child, 'legend-marker');
      if (!markerItem) return;

      if (_this2.get('highlight')) {
        var oriStroke = markerItem.get('oriStroke');
        var checked = child.get('checked');
        if (oriStroke && !checked) oriStroke = unCheckColor;else oriStroke = '';
        markerItem.attr('stroke', oriStroke);
      } else {
        markerItem.attr('fillOpacity', self.get('inactiveOpacity'));
      }
    });
    this.get('canvas').draw();
    return;
  } // mouse move listener of an item
  // when mouse over an item, reduce the opacity of the other items.
  ;

  _proto._onMousemove = function _onMousemove(ev) {
    var item = this._getLegendItem(ev.currentTarget);

    if (item && item.get('checked')) {
      var items = this.get('items');
      var itemhover = new Event('itemhover', ev, true, true);
      itemhover.item = findItem(items, item);
      itemhover.checked = item.get('checked');
      itemhover.currentTarget = ev.currentTarget; // change the opacity of other items

      this.deactivate();
      this.activate(item.get('value'));
      this.emit('itemhover', itemhover);
    } else {
      this.deactivate();
      this.emit('itemunhover', ev);
    }

    this.get('canvas').draw();
    return;
  } // mouse leave listener of an item
  ;

  _proto._onMouseleave = function _onMouseleave(ev) {
    this.deactivate();
    this.get('canvas').draw();
    this.emit('itemunhover', ev);
    return;
  } // the click listener of an item
  ;

  _proto._onClick = function _onClick(ev) {
    var clickedItem = this._getLegendItem(ev.currentTarget);

    var items = this.get('items');

    if (clickedItem && !clickedItem.get('destroyed')) {
      var checked = clickedItem.get('checked');
      var mode = this.get('selectedMode');
      var item = findItem(items, clickedItem);
      var itemclick = new Event('itemclick', ev, true, true);
      itemclick.item = item;
      itemclick.currentTarget = clickedItem;
      itemclick.appendInfo = ev.currentTarget.get('appendInfo');
      itemclick.checked = mode === 'single' ? true : !checked;

      if (!this.get('allowAllCanceled') && checked && this.getCheckedCount() === 1) {
        this.emit('clicklastitem', itemclick);
        return;
      }

      var unCheckColor = this.get('unCheckColor');
      var checkColor = this.get('textStyle').fill;
      var markerItem = void 0;
      var textItem = void 0;
      var legendItem = void 0;

      if (mode === 'single') {
        var itemsGroup = this.get('itemsGroup');
        var children = itemsGroup.get('children');
        Util.each(children, function (child) {
          markerItem = findShapeByName(child, 'legend-marker');
          textItem = findShapeByName(child, 'legend-text');
          legendItem = findShapeByName(child, 'legend-item');

          if (child !== clickedItem) {
            if (markerItem.attr('fill')) {
              markerItem.attr('fill', unCheckColor);
            }

            if (markerItem.attr('stroke')) {
              markerItem.attr('stroke', unCheckColor);
            }

            textItem.attr('fill', unCheckColor);
            markerItem.setSilent('checked', false);
            textItem.setSilent('checked', false);
            legendItem.setSilent('checked', false);
            child.setSilent('checked', false);
          } else {
            if (markerItem.attr('fill')) {
              item && item.marker && markerItem.attr('fill', item.marker.fill);
            }

            if (markerItem.attr('stroke')) {
              item && item.marker && markerItem.attr('stroke', item.marker.stroke);
            }

            textItem.attr('fill', checkColor);
            markerItem.setSilent('checked', true);
            textItem.setSilent('checked', true);
            legendItem.setSilent('checked', true);
            child.setSilent('checked', true);
          }
        });
      } else {
        markerItem = findShapeByName(clickedItem, 'legend-marker');
        textItem = findShapeByName(clickedItem, 'legend-text');
        legendItem = findShapeByName(clickedItem, 'legend-item');

        if (markerItem.attr('fill')) {
          item && item.marker && markerItem.attr('fill', checked ? unCheckColor : item.marker.fill);
        }

        if (markerItem.attr('stroke')) {
          item && item.marker && markerItem.attr('stroke', checked ? unCheckColor : item.marker.stroke);
        }

        textItem.attr('fill', checked ? unCheckColor : checkColor);
        clickedItem.setSilent('checked', !checked);
        markerItem.setSilent('checked', !checked);
        textItem.setSilent('checked', !checked);
        legendItem.setSilent('checked', !checked);
      }

      this.emit('itemclick', itemclick);
    }

    this.get('canvas').draw();
    return;
  } // render the items
  ;

  _proto._renderItems = function _renderItems() {
    var _this3 = this;

    var items = this.get('items');

    if (this.get('reversed')) {
      items.reverse();
    }

    Util.each(items, function (item, index) {
      _this3._addItem(item, index);
    });

    if (this.get('highlight')) {
      var itemsGroup = this.get('itemsGroup');
      var children = itemsGroup.get('children');
      var markerItem = void 0;
      children.forEach(function (child) {
        markerItem = findShapeByName(child, 'legend-marker');
        var oriStroke = markerItem.get('oriStroke');

        if (!oriStroke) {
          if (markerItem.attr('stroke')) markerItem.set('oriStroke', markerItem.attr('stroke'));else markerItem.set('oriStroke', '');
        }
      });
    }
  } // format the item value
  ;

  _proto._formatItemValue = function _formatItemValue(value) {
    var formatter = this.get('formatter') || this.get('itemFormatter');

    if (formatter) {
      value = formatter.call(this, value);
    }

    return value;
  } // find x of next item
  ;

  _proto._getNextX = function _getNextX() {
    var layout = this.get('layout');
    var itemGap = this.get('itemGap');
    var itemsGroup = this.get('itemsGroup');
    var itemWidth = this.get('itemWidth');
    var children = itemsGroup.get('children');
    var nextX = 0;

    if (layout === 'horizontal') {
      // 水平布局
      Util.each(children, function (v) {
        nextX += (itemWidth ? itemWidth : v.getBBox().width) + itemGap;
      });
    }

    return nextX;
  } // find y of next item
  ;

  _proto._getNextY = function _getNextY() {
    var itemMarginBottom = this.get('itemMarginBottom');
    var titleGap = this.get('titleShape') ? this.get('titleGap') : 0;
    var layout = this.get('layout');
    var itemsGroup = this.get('itemsGroup');
    var titleShape = this.get('titleShape');
    var children = itemsGroup.get('children');
    var nextY = titleGap;

    if (titleShape) {
      nextY += titleShape.getBBox().height;
    }

    if (layout === 'vertical') {
      // 竖直布局
      Util.each(children, function (v) {
        nextY += v.getBBox().height + itemMarginBottom;
      });
    }

    return nextY;
  } // add an item to the canvas
  ;

  _proto._addItem = function _addItem(item) {
    var itemsGroup = this.get('itemsGroup');

    var x = this._getNextX();

    var y = this._getNextY();

    var unCheckColor = this.get('unCheckColor');
    var itemGroup = itemsGroup.addGroup({
      x: x,
      y: y,
      value: item.value,
      checked: item.checked
    }); // @2018-10-20 by blue.lb 需要设置viewId，否则在emit的时候，parent获取不到viewId

    itemGroup.set('viewId', this.get('viewId'));
    var textStyle = this.get('textStyle');
    var wordSpace = this.get('_wordSpaceing');
    var startX = 0;

    if (item.marker) {
      // 如果有marker添加marker
      var markerAttrs = Util.mix({}, item.marker, {
        x: item.marker.radius + x,
        y: y
      });

      if (!item.checked) {
        if (markerAttrs.fill) {
          markerAttrs.fill = unCheckColor;
        }

        if (markerAttrs.stroke) {
          markerAttrs.stroke = unCheckColor;
        }
      }

      var markerShape = itemGroup.addShape('marker', {
        type: 'marker',
        attrs: markerAttrs
      });
      markerShape.attr('cursor', 'pointer');
      markerShape.name = 'legend-marker';
      startX += markerShape.getBBox().width + wordSpace;
    }

    var textAttrs = Util.mix({}, {
      fill: '#333',
      fontSize: 12,
      textAlign: 'start',
      textBaseline: 'middle',
      fontFamily: FONT_FAMILY
    }, textStyle, {
      x: startX + x,
      y: y,
      text: this._formatItemValue(item.value)
    });

    if (!item.checked) {
      Util.mix(textAttrs, {
        fill: unCheckColor
      });
    }

    var textShape = itemGroup.addShape('text', {
      attrs: textAttrs
    });
    textShape.attr('cursor', 'pointer');
    textShape.name = 'legend-text';
    this.get('appendInfo') && textShape.setSilent('appendInfo', this.get('appendInfo')); // 添加一个包围矩形，用于事件支持

    var bbox = itemGroup.getBBox();
    var itemWidth = this.get('itemWidth');
    var wrapperShape = itemGroup.addShape('rect', {
      attrs: {
        x: x,
        y: y - bbox.height / 2,
        fill: '#fff',
        fillOpacity: 0,
        width: itemWidth || bbox.width,
        height: bbox.height
      }
    });
    wrapperShape.attr('cursor', 'pointer');
    wrapperShape.setSilent('origin', item); // 保存图例项相关的数据，便于事件操作

    wrapperShape.name = 'legend-item';
    this.get('appendInfo') && wrapperShape.setSilent('appendInfo', this.get('appendInfo'));
    itemGroup.name = 'legendGroup';
    return itemGroup;
  } // auto break the line for horizontal layout
  ;

  _proto._adjustHorizontal = function _adjustHorizontal() {
    var itemsGroup = this.get('itemsGroup');
    var children = itemsGroup.get('children');
    var maxLength = this.get('maxLength');
    var itemGap = this.get('itemGap');
    var itemMarginBottom = this.get('itemMarginBottom');
    var titleGap = this.get('titleShape') ? this.get('titleGap') : 0;
    var row = 0;
    var rowLength = 0;
    var width = void 0;
    var height = void 0;
    var box = void 0;
    var itemWidth = this.get('itemWidth');

    if (itemsGroup.getBBox().width > maxLength) {
      Util.each(children, function (child) {
        box = child.getBBox();
        width = itemWidth || box.width;
        height = box.height + itemMarginBottom;

        if (maxLength - rowLength < width) {
          row++;
          rowLength = 0;
        }

        child.move(rowLength, row * height + titleGap);
        rowLength += width + itemGap;
      });
    }

    return;
  } // auto break the column for vertical layout
  ;

  _proto._adjustVertical = function _adjustVertical() {
    var itemsGroup = this.get('itemsGroup');
    var titleShape = this.get('titleShape');
    var children = itemsGroup.get('children');
    var maxLength = this.get('maxLength'); // 垂直布局，则 maxLength 代表容器的高度

    var itemGap = this.get('itemGap');
    var itemMarginBottom = this.get('itemMarginBottom');
    var titleGap = this.get('titleGap');
    var titleHeight = titleShape ? titleShape.getBBox().height + titleGap : 0;
    var itemWidth = this.get('itemWidth');
    var colLength = titleHeight;
    var width = void 0;
    var height = void 0;
    var box = void 0;
    var maxItemWidth = 0;
    var totalLength = 0;

    if (itemsGroup.getBBox().height > maxLength) {
      Util.each(children, function (v) {
        box = v.getBBox();
        width = box.width;
        height = box.height;

        if (itemWidth) {
          maxItemWidth = itemWidth + itemGap;
        } else if (width > maxItemWidth) {
          maxItemWidth = width + itemGap;
        }

        if (maxLength - colLength < height) {
          colLength = titleHeight;
          totalLength += maxItemWidth;
          v.move(totalLength, titleHeight);
        } else {
          v.move(totalLength, colLength);
        }

        colLength += height + itemMarginBottom;
      });
    }

    return;
  } // automatically break the line / column while the width / height exceeds maxLength
  ;

  _proto._adjustItems = function _adjustItems() {
    var layout = this.get('layout');

    if (layout === 'horizontal') {
      this._adjustHorizontal();
    } else {
      this._adjustVertical();
    }
  };

  _proto.getWidth = function getWidth() {
    return _Legend.prototype.getWidth.call(this);
  };

  _proto.getHeight = function getHeight() {
    return _Legend.prototype.getHeight.call(this);
  };

  _proto.move = function move(x, y) {
    _Legend.prototype.move.call(this, x, y);
  };

  return Category;
}(Legend);

module.exports = Category;