function _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

var Util = require('../util');

var Component = require('../component');

var _require = require('../const'),
    FONT_FAMILY = _require.FONT_FAMILY;

var Legend = /*#__PURE__*/function (_Component) {
  _inheritsLoose(Legend, _Component);

  var _proto = Legend.prototype;

  _proto.getDefaultCfg = function getDefaultCfg() {
    return {
      /**
       * Group 容器
       * @type {Object}
       */
      container: null,

      /**
       * 图例标题配置
       * @type {Object}
       */
      title: null,

      /**
       * 图例项文本格式化
       * @type {Function}
       */
      formatter: null,

      /**
       * 鼠标 hover 到图例上的默认交互是否开启
       * @type {Boolean}
       */
      hoverable: true,

      /**
       * TODO：rename
       * 图例标题距离图例项的距离
       * @type {Number}
       */
      titleGap: 15,

      /**
       * legend 相对于 container 的位置
       * @type {Array}
       */
      position: [0, 0],

      /**
       * legend 在 position 位置上的偏移量
       * @type {Array}
       */
      offset: [0, 0],

      /**
       * legend 在 position 位置上沿 x 轴的偏移量。若同时设置了 offset 和 offsetX， 以 offsetX 为准
       * @type {Number}
       */
      offsetX: null,

      /**
       * legend 在 position 位置上沿 y 轴的偏移量。若同时设置了 offset 和 offsetY， 以 offsetY 为准
       * @type {Number}
       */
      offsetY: null
    };
  };

  function Legend(cfg) {
    var _this;

    _this = _Component.call(this, cfg) || this;

    _this._init();

    _this.beforeRender();

    _this.render();

    _this._adjustPositionOffset();

    _this._bindEvents();

    return _this;
  }

  _proto._init = function _init() {
    var group = this.get('group');
    var container = this.get('container');
    this.set('canvas', container.get('canvas'));
    var position = this.get('position');
    if (!group) group = container.addGroup({
      x: 0 - position[0],
      y: 0 - position[1]
    });
    this.set('group', group);
  };

  _proto._adjustPositionOffset = function _adjustPositionOffset() {
    var position = this.get('position');
    var offset = this.get('offset');
    var offsetX = this.get('offsetX');
    var offsetY = this.get('offsetY');

    if (!Util.isArray(offset)) {
      var layout = this.get('layout');
      offset = layout === 'vertical' ? [offset, 0] : [0, offset];
    }

    if (offsetX) offset[0] = offsetX;
    if (offsetY) offset[1] = offsetY;
    var bbox = this.get('group').getBBox();
    this.move(-bbox.minX + position[0] + offset[0], -bbox.minY + position[1] + offset[1]);
  };

  _proto.beforeRender = function beforeRender() {
    var group = this.get('group');
    var itemsGroup = group.addGroup();
    this.set('itemsGroup', itemsGroup);
  };

  _proto.render = function render() {
    this._renderTitle();
  } // render the title of the legend
  ;

  _proto._renderTitle = function _renderTitle() {
    var title = this.get('title');
    var titleGap = this.get('titleGap');
    titleGap = titleGap || 0;

    if (title && title.text) {
      var group = this.get('group');
      var titleShape = group.addShape('text', {
        attrs: Util.mix({
          x: 0,
          y: 0 - titleGap,
          fill: '#333',
          textBaseline: 'middle',
          fontFamily: FONT_FAMILY
        }, title)
      });
      titleShape.name = 'legend-title';
      this.get('appendInfo') && titleShape.setSilent('appendInfo', this.get('appendInfo'));
      this.set('titleShape', titleShape);
    }
  } // return the count of checked items
  ;

  _proto.getCheckedCount = function getCheckedCount() {
    var itemsGroup = this.get('itemsGroup');
    var items = itemsGroup.get('children');
    var checkedArr = Util.filter(items, function (item) {
      return item.get('checked');
    });
    return checkedArr.length;
  } // set items for the legend
  ;

  _proto.setItems = function setItems(items) {
    this.set('items', items);
    this.clear();
    this.render();
  } // add an item into the legend
  ;

  _proto.addItem = function addItem(item) {
    var items = this.get('items');
    items.push(item);
    this.clear();
    this.render();
  } // clear all the items of the legend
  ;

  _proto.clear = function clear() {
    var itemsGroup = this.get('itemsGroup');
    itemsGroup.clear();
    var group = this.get('group');
    group.clear();
    this.beforeRender();
  } // destroy the legend
  ;

  _proto.destroy = function destroy() {
    var group = this.get('group');
    group && group.destroy();
    this._attrs = {};
    this.removeAllListeners();

    _Component.prototype.destroy.call(this); // 要最后调用 super.destroy 否则 get 属性会无效

  } // return the width of the legend
  ;

  _proto.getWidth = function getWidth() {
    var bbox = this.get('group').getBBox();
    return bbox.width;
  } // return the height of the legend
  ;

  _proto.getHeight = function getHeight() {
    var bbox = this.get('group').getBBox();
    return bbox.height;
  };

  _proto.move = function move(x, y) {
    this.get('group').move(x, y);
  };

  _proto.draw = function draw() {
    this.get('canvas').draw();
  };

  return Legend;
}(Component);

module.exports = Legend;