function _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

var Util = require('../util');

var Guide = require('./base');

var Text = /*#__PURE__*/function (_Guide) {
  _inheritsLoose(Text, _Guide);

  function Text() {
    return _Guide.apply(this, arguments) || this;
  }

  var _proto = Text.prototype;

  _proto.getDefaultCfg = function getDefaultCfg() {
    var cfg = _Guide.prototype.getDefaultCfg.call(this);

    return Util.mix({}, cfg, {
      /**
       * 辅助元素类型
       * @type {String}
       */
      name: 'text',

      /**
       * 辅助文本的位置
       * @type {Object | Function | Array}
       */
      position: null,

      /**
       * 辅助文本的显示文字
       * @type {String}
       */
      content: null,

      /**
       * 辅助文本的样式配置
       * @type {Object}
       */
      style: {
        fill: '#999',
        fontSize: 12,
        fontWeight: 500,
        textAlign: 'center'
      },

      /**
       * x 方向的偏移量
       * @type {Number}
       */
      offsetX: null,

      /**
       * y 方向的偏移量
       * @type {Number}
       */
      offsetY: null,
      top: true
    });
  };

  _proto.render = function render(coord, group) {
    var self = this;
    var point = self.parsePoint(coord, self.get('position'));

    if (!point) {
      return;
    }

    var textStyle = Util.mix({}, self.get('style'));
    var offsetX = self.get('offsetX');
    var offsetY = self.get('offsetY');

    if (offsetX) {
      point.x += offsetX;
    }

    if (offsetY) {
      point.y += offsetY;
    }

    if (textStyle.rotate) {
      textStyle.rotate = textStyle.rotate * Math.PI / 180; // 将角度转换为弧度
    }

    var guideText = group.addShape('Text', {
      zIndex: self.get('zIndex'),
      attrs: Util.mix({
        text: self.get('content')
      }, textStyle, point)
    });
    guideText.name = 'guide-text';
    self.get('appendInfo') && guideText.setSilent('appendInfo', self.get('appendInfo'));
    self.set('el', guideText);
  };

  return Text;
}(Guide);

module.exports = Text;