function _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

var Util = require('../util');

var Guide = require('./base');

var Region = /*#__PURE__*/function (_Guide) {
  _inheritsLoose(Region, _Guide);

  function Region() {
    return _Guide.apply(this, arguments) || this;
  }

  var _proto = Region.prototype;

  _proto.getDefaultCfg = function getDefaultCfg() {
    var cfg = _Guide.prototype.getDefaultCfg.call(this);

    return Util.mix({}, cfg, {
      name: 'region',
      zIndex: 1,
      start: null,
      end: null,
      style: {
        lineWidth: 0,
        fill: '#CCD7EB',
        opacity: 0.4
      }
    });
  };

  _proto.render = function render(coord, group) {
    var self = this;
    var rectStyle = self.get('style');

    var path = self._getPath(coord);

    if (!path.length) {
      // path 为空时不绘制
      return;
    }

    var regionGroup = group.addShape('path', {
      zIndex: self.get('zIndex'),
      attrs: Util.mix({
        path: path
      }, rectStyle)
    });
    regionGroup.name = 'guide-region';
    self.get('appendInfo') && regionGroup.setSilent('appendInfo', self.get('appendInfo'));
    self.set('el', regionGroup);
  };

  _proto._getPath = function _getPath(coord) {
    var self = this;
    var start = self.parsePoint(coord, self.get('start'));
    var end = self.parsePoint(coord, self.get('end'));

    if (!start || !end) {
      return [];
    }

    var path = [['M', start.x, start.y], ['L', end.x, start.y], ['L', end.x, end.y], ['L', start.x, end.y], ['z']];
    return path;
  };

  return Region;
}(Guide);

module.exports = Region;