function _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

var Util = require('../util');

var Guide = require('./base');

var Image = /*#__PURE__*/function (_Guide) {
  _inheritsLoose(Image, _Guide);

  function Image() {
    return _Guide.apply(this, arguments) || this;
  }

  var _proto = Image.prototype;

  _proto.getDefaultCfg = function getDefaultCfg() {
    var cfg = _Guide.prototype.getDefaultCfg.call(this);

    return Util.mix({}, cfg, {
      type: 'image',

      /**
       * the start of image
       * @type {Object | Function | Array}
       */
      start: null,

      /**
       * the end of image
       * @type {Object | Function | Array}
       */
      end: null,

      /**
       * image url
       * @type {String}
       */
      src: null,

      /**
       * Horizontal offset
       * @type {Number}
       */
      offsetX: null,

      /**
       * Vertical offset
       * @type {Number}
       */
      offsetY: null
    });
  };

  _proto.render = function render(coord, group) {
    var self = this;
    var start = self.parsePoint(coord, self.get('start'));

    if (!start) {
      return;
    }

    var cfg = {
      x: start.x,
      y: start.y
    };
    cfg.img = self.get('src');

    if (!self.get('end')) {
      // 如果咩有指定结束点，则 start 为图片的左上角坐标
      cfg.width = self.get('width') || 32;
      cfg.height = self.get('height') || 32;
    } else {
      var end = self.parsePoint(coord, self.get('end'));

      if (!end) {
        return;
      } // cfg.width = Math.abs(end.x - start.x);
      // cfg.height = Math.abs(end.y - start.y);


      cfg.width = end.x - start.x;
      cfg.height = end.y - start.y;
    }

    if (self.get('offsetX')) {
      cfg.x += self.get('offsetX');
    }

    if (self.get('offsetY')) {
      cfg.y += self.get('offsetY');
    }

    var imgGuide = group.addShape('Image', {
      zIndex: 1,
      attrs: cfg
    });
    imgGuide.name = 'guide-image';
    self.get('appendInfo') && imgGuide.setSilent('appendInfo', self.get('appendInfo'));
    self.set('el', imgGuide);
  };

  return Image;
}(Guide);

module.exports = Image;